/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.util;

import cn.afterturn.easypoi.exception.excel.ExcelExportException;
import cn.afterturn.easypoi.util.PoiFunctionUtil;
import cn.afterturn.easypoi.util.PoiPublicUtil;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Stack;

public final class PoiElUtil {
    public static final String LENGTH = "le:";
    public static final String FOREACH = "fe:";
    public static final String FOREACH_NOT_CREATE = "!fe:";
    public static final String FOREACH_AND_SHIFT = "$fe:";
    public static final String FOREACH_COL = "#fe:";
    public static final String FOREACH_COL_VALUE = "v_fe:";
    public static final String START_STR = "{{";
    public static final String END_STR = "}}";
    public static final String WRAP = "]]";
    public static final String NUMBER_SYMBOL = "n:";
    public static final String MERGE = "merge:";
    public static final String STYLE_SELF = "sy:";
    public static final String FORMAT_DATE = "fd:";
    public static final String FORMAT_NUMBER = "fn:";
    public static final String SUM = "sum:";
    public static final String IF_DELETE = "!if:";
    public static final String EMPTY = "";
    public static final String CONST = "'";
    public static final String NULL = "&NULL&";
    public static final String INDEX = "&INDEX&";
    public static final String LEFT_BRACKET = "(";
    public static final String RIGHT_BRACKET = ")";
    public static final String CAL = "cal:";
    public static final String DICT_HANDLER = "dict:";
    public static final String I18N_HANDLER = "i18n:";
    public static final String DESENSITIZATION_RULE = "deru:";

    private PoiElUtil() {
    }

    public static Object eval(String text, Map<String, Object> map) throws Exception {
        Object obj = PoiElUtil.innerEval(text, map);
        if (text.equals(obj.toString())) {
            if (map.containsKey(text.split("\\.")[0])) {
                return PoiPublicUtil.getParamsValue(text, map);
            }
            return EMPTY;
        }
        return obj;
    }

    public static String evalFindName(String text, Map<String, Object> map) throws Exception {
        String[] keys = text.split("\\.");
        StringBuilder sb = new StringBuilder().append(keys[0]);
        for (int i = 1; i < keys.length; ++i) {
            sb.append(".").append(keys[i]);
            if (!(PoiElUtil.eval(sb.toString(), map) instanceof Collection)) continue;
            return sb.toString();
        }
        return null;
    }

    public static Object evalNoParse(String text, Map<String, Object> map) throws Exception {
        String tempText = new String(text);
        Object obj = PoiElUtil.innerEval(text, map);
        if (tempText.equals(obj.toString())) {
            if (map.containsKey(tempText.split("\\.")[0])) {
                return PoiPublicUtil.getParamsValue(tempText, map);
            }
            return obj;
        }
        return obj;
    }

    public static Object innerEval(String text, Map<String, Object> map) throws Exception {
        if (text.indexOf("?") != -1 && text.indexOf(":") != -1) {
            return PoiElUtil.trinocular(text, map);
        }
        if (text.indexOf(LENGTH) != -1) {
            return PoiElUtil.length(text, map);
        }
        if (text.indexOf(FORMAT_DATE) != -1) {
            return PoiElUtil.formatDate(text, map);
        }
        if (text.indexOf(FORMAT_NUMBER) != -1) {
            return PoiElUtil.formatNumber(text, map);
        }
        if (text.indexOf(IF_DELETE) != -1) {
            return PoiElUtil.ifDelete(text, map);
        }
        if (text.indexOf(CAL) != -1) {
            return PoiElUtil.calculate(text, map);
        }
        if (text.startsWith(CONST)) {
            return text.replace(CONST, EMPTY);
        }
        return text;
    }

    private static Object calculate(String text, Map<String, Object> map) throws Exception {
        text = text.replace(CAL, EMPTY);
        StringBuilder sb = new StringBuilder();
        StringBuilder temp = new StringBuilder();
        char[] chars = text.toCharArray();
        char[] operations = new char[]{'+', '-', '*', '/', '(', ')', ' '};
        boolean beforeMark = true;
        for (int i = 0; i < chars.length; ++i) {
            if (operations[0] == chars[i] || operations[1] == chars[i] || operations[2] == chars[i] || operations[3] == chars[i] || operations[4] == chars[i] || operations[5] == chars[i]) {
                if (temp.length() > 0) {
                    sb.append(PoiElUtil.evalNoParse(temp.toString().trim(), map).toString());
                    temp = new StringBuilder();
                }
                sb.append(chars[i]);
                beforeMark = true;
                continue;
            }
            if (!beforeMark) continue;
            temp.append(chars[i]);
        }
        if (temp.length() > 0) {
            sb.append(PoiElUtil.evalNoParse(temp.toString().trim(), map).toString());
        }
        return Calculator.conversion(sb.toString());
    }

    private static Object ifDelete(String text, Map<String, Object> map) throws Exception {
        text = text.replaceAll("\\s{1,}", " ").trim();
        String[] keys = PoiElUtil.getKey(IF_DELETE, text).split(" ");
        text = text.replace(IF_DELETE, EMPTY);
        return PoiElUtil.isTrue(keys, map);
    }

    private static Boolean isTrue(String[] keys, Map<String, Object> map) throws Exception {
        if (keys.length == 1) {
            String constant = null;
            constant = PoiElUtil.isConstant(keys[0]);
            if (constant != null) {
                return Boolean.valueOf(constant);
            }
            return Boolean.valueOf(PoiElUtil.eval(keys[0], map).toString());
        }
        if (keys.length == 3) {
            Object first = PoiElUtil.evalNoParse(keys[0], map);
            Object second = PoiElUtil.evalNoParse(keys[2], map);
            return PoiFunctionUtil.isTrue(first, keys[1], second);
        }
        throw new ExcelExportException("\u5224\u65ad\u53c2\u6570\u4e0d\u5bf9");
    }

    private static String isConstant(String param) {
        if (param.indexOf(CONST) != -1) {
            return param.replace(CONST, EMPTY);
        }
        return null;
    }

    private static Object formatNumber(String text, Map<String, Object> map) throws Exception {
        String[] key = PoiElUtil.getKey(FORMAT_NUMBER, text).split(";");
        text = text.replace(FORMAT_NUMBER, EMPTY);
        return PoiElUtil.innerEval(PoiElUtil.replacinnerEvalue(text, PoiFunctionUtil.formatNumber(PoiElUtil.eval(key[0], map), key[1])), map);
    }

    private static Object formatDate(String text, Map<String, Object> map) throws Exception {
        String[] key = PoiElUtil.getKey(FORMAT_DATE, text).split(";");
        text = text.replace(FORMAT_DATE, EMPTY);
        return PoiElUtil.innerEval(PoiElUtil.replacinnerEvalue(text, PoiFunctionUtil.formatDate(PoiElUtil.eval(key[0], map), key[1])), map);
    }

    private static Object length(String text, Map<String, Object> map) throws Exception {
        String key = PoiElUtil.getKey(LENGTH, text);
        text = text.replace(LENGTH, EMPTY);
        Object val = PoiElUtil.eval(key, map);
        return PoiElUtil.innerEval(PoiElUtil.replacinnerEvalue(text, PoiFunctionUtil.length(val)), map);
    }

    private static String replacinnerEvalue(String text, Object val) {
        StringBuilder sb = new StringBuilder();
        sb.append(text.substring(0, text.indexOf(LEFT_BRACKET)));
        sb.append(" ");
        sb.append(val);
        sb.append(" ");
        sb.append(text.substring(text.indexOf(RIGHT_BRACKET) + 1, text.length()));
        return sb.toString().trim();
    }

    private static String getKey(String prefix, String text) {
        int leftBracket = 1;
        int rigthBracket = 0;
        int position = 0;
        int index = text.indexOf(prefix) + prefix.length();
        while (text.charAt(index) == " ".charAt(0)) {
            text = text.substring(0, index) + text.substring(index + 1, text.length());
        }
        for (int i = text.indexOf(new StringBuilder().append(prefix).append(LEFT_BRACKET).toString()) + prefix.length() + 1; i < text.length(); ++i) {
            if (text.charAt(i) == LEFT_BRACKET.charAt(0)) {
                ++leftBracket;
            }
            if (text.charAt(i) == RIGHT_BRACKET.charAt(0)) {
                ++rigthBracket;
            }
            if (leftBracket != rigthBracket) continue;
            position = i;
            break;
        }
        return text.substring(text.indexOf(prefix + LEFT_BRACKET) + 1 + prefix.length(), position).trim();
    }

    private static Object trinocular(String text, Map<String, Object> map) throws Exception {
        text = text.replaceAll("\\s{1,}", " ").trim();
        String testText = text.substring(0, text.indexOf("?"));
        text = text.substring(text.indexOf("?") + 1, text.length()).trim();
        text = PoiElUtil.innerEval(text, map).toString();
        String[] keys = text.split(":");
        Object first = null;
        Object second = null;
        if (keys.length > 2) {
            if (keys[0].trim().contains("?")) {
                String trinocular = keys[0];
                for (int i = 1; i < keys.length - 1; ++i) {
                    trinocular = trinocular + ":" + keys[i];
                }
                first = PoiElUtil.evalNoParse(trinocular, map);
                second = PoiElUtil.evalNoParse(keys[keys.length - 1].trim(), map);
            } else {
                first = PoiElUtil.evalNoParse(keys[0].trim(), map);
                String trinocular = keys[1];
                for (int i = 2; i < keys.length; ++i) {
                    trinocular = trinocular + ":" + keys[i];
                }
                second = PoiElUtil.evalNoParse(trinocular, map);
            }
        } else {
            first = PoiElUtil.evalNoParse(keys[0].trim(), map);
            second = PoiElUtil.evalNoParse(keys[1].trim(), map);
        }
        return PoiElUtil.isTrue(testText.split(" "), map) != false ? first : second;
    }

    private static class ArithHelper {
        private static final int DEF_DIV_SCALE = 16;

        private ArithHelper() {
        }

        public static double add(double v1, double v2) {
            BigDecimal b1 = new BigDecimal(Double.toString(v1));
            BigDecimal b2 = new BigDecimal(Double.toString(v2));
            return b1.add(b2).doubleValue();
        }

        public static double add(String v1, String v2) {
            BigDecimal b1 = new BigDecimal(v1);
            BigDecimal b2 = new BigDecimal(v2);
            return b1.add(b2).doubleValue();
        }

        public static double sub(double v1, double v2) {
            BigDecimal b1 = new BigDecimal(Double.toString(v1));
            BigDecimal b2 = new BigDecimal(Double.toString(v2));
            return b1.subtract(b2).doubleValue();
        }

        public static double sub(String v1, String v2) {
            BigDecimal b1 = new BigDecimal(v1);
            BigDecimal b2 = new BigDecimal(v2);
            return b1.subtract(b2).doubleValue();
        }

        public static double mul(double v1, double v2) {
            BigDecimal b1 = new BigDecimal(Double.toString(v1));
            BigDecimal b2 = new BigDecimal(Double.toString(v2));
            return b1.multiply(b2).doubleValue();
        }

        public static double mul(String v1, String v2) {
            BigDecimal b1 = new BigDecimal(v1);
            BigDecimal b2 = new BigDecimal(v2);
            return b1.multiply(b2).doubleValue();
        }

        public static double div(double v1, double v2) {
            return ArithHelper.div(v1, v2, 16);
        }

        public static double div(String v1, String v2) {
            BigDecimal b1 = new BigDecimal(v1);
            BigDecimal b2 = new BigDecimal(v2);
            return b1.divide(b2, 16, 4).doubleValue();
        }

        public static double div(double v1, double v2, int scale) {
            if (scale < 0) {
                throw new IllegalArgumentException("The   scale   must   be   a   positive   integer   or   zero");
            }
            BigDecimal b1 = new BigDecimal(Double.toString(v1));
            BigDecimal b2 = new BigDecimal(Double.toString(v2));
            return b1.divide(b2, scale, 4).doubleValue();
        }

        public static double round(double v, int scale) {
            if (scale < 0) {
                throw new IllegalArgumentException("The   scale   must   be   a   positive   integer   or   zero");
            }
            BigDecimal b = new BigDecimal(Double.toString(v));
            BigDecimal one = new BigDecimal("1");
            return b.divide(one, scale, 4).doubleValue();
        }

        public static double round(String v, int scale) {
            if (scale < 0) {
                throw new IllegalArgumentException("The   scale   must   be   a   positive   integer   or   zero");
            }
            BigDecimal b = new BigDecimal(v);
            BigDecimal one = new BigDecimal("1");
            return b.divide(one, scale, 4).doubleValue();
        }
    }

    private static class Calculator {
        private Stack<String> postfixStack = new Stack();
        private Stack<Character> opStack = new Stack();
        private int[] operatPriority = new int[]{0, 3, 2, 1, -1, 1, 0, 2};

        private Calculator() {
        }

        public static Object conversion(String expression) {
            double result = 0.0;
            Calculator cal = new Calculator();
            try {
                expression = Calculator.transform(expression);
                result = cal.calculate(expression);
            }
            catch (Exception e) {
                return "NaN";
            }
            return result;
        }

        private static String transform(String expression) {
            char[] arr = expression.toCharArray();
            for (int i = 0; i < arr.length; ++i) {
                if (arr[i] != '-') continue;
                if (i == 0) {
                    arr[i] = 126;
                    continue;
                }
                char c = arr[i - 1];
                if (c != '+' && c != '-' && c != '*' && c != '/' && c != '(' && c != 'E' && c != 'e') continue;
                arr[i] = 126;
            }
            if (arr[0] == '~' || arr[1] == '(') {
                arr[0] = 45;
                return "0" + new String(arr);
            }
            return new String(arr);
        }

        public double calculate(String expression) {
            Stack<String> resultStack = new Stack<String>();
            this.prepare(expression);
            Collections.reverse(this.postfixStack);
            while (!this.postfixStack.isEmpty()) {
                String currentValue = this.postfixStack.pop();
                if (!this.isOperator(currentValue.charAt(0))) {
                    currentValue = currentValue.replace("~", "-");
                    resultStack.push(currentValue);
                    continue;
                }
                String secondValue = (String)resultStack.pop();
                String firstValue = (String)resultStack.pop();
                firstValue = firstValue.replace("~", "-");
                secondValue = secondValue.replace("~", "-");
                String tempResult = this.calculate(firstValue, secondValue, currentValue.charAt(0));
                resultStack.push(tempResult);
            }
            return Double.valueOf((String)resultStack.pop());
        }

        private void prepare(String expression) {
            this.opStack.push(Character.valueOf(','));
            char[] arr = expression.toCharArray();
            int currentIndex = 0;
            int count = 0;
            for (int i = 0; i < arr.length; ++i) {
                char currentOp = arr[i];
                if (this.isOperator(currentOp)) {
                    if (count > 0) {
                        this.postfixStack.push(new String(arr, currentIndex, count));
                    }
                    char peekOp = this.opStack.peek().charValue();
                    if (currentOp == ')') {
                        while (this.opStack.peek().charValue() != '(') {
                            this.postfixStack.push(String.valueOf(this.opStack.pop()));
                        }
                        this.opStack.pop();
                    } else {
                        while (currentOp != '(' && peekOp != ',' && this.compare(currentOp, peekOp)) {
                            this.postfixStack.push(String.valueOf(this.opStack.pop()));
                            peekOp = this.opStack.peek().charValue();
                        }
                        this.opStack.push(Character.valueOf(currentOp));
                    }
                    count = 0;
                    currentIndex = i + 1;
                    continue;
                }
                ++count;
            }
            if (count > 1 || count == 1 && !this.isOperator(arr[currentIndex])) {
                this.postfixStack.push(new String(arr, currentIndex, count));
            }
            while (this.opStack.peek().charValue() != ',') {
                this.postfixStack.push(String.valueOf(this.opStack.pop()));
            }
        }

        private boolean isOperator(char c) {
            return c == '+' || c == '-' || c == '*' || c == '/' || c == '(' || c == ')';
        }

        public boolean compare(char cur, char peek) {
            boolean result = false;
            if (this.operatPriority[peek - 40] >= this.operatPriority[cur - 40]) {
                result = true;
            }
            return result;
        }

        private String calculate(String firstValue, String secondValue, char currentOp) {
            String result = PoiElUtil.EMPTY;
            switch (currentOp) {
                case '+': {
                    result = String.valueOf(ArithHelper.add(firstValue, secondValue));
                    break;
                }
                case '-': {
                    result = String.valueOf(ArithHelper.sub(firstValue, secondValue));
                    break;
                }
                case '*': {
                    result = String.valueOf(ArithHelper.mul(firstValue, secondValue));
                    break;
                }
                case '/': {
                    result = String.valueOf(ArithHelper.div(firstValue, secondValue));
                }
            }
            return result;
        }
    }
}

