/*
 * Decompiled with CFR 0.152.
 */
package ch.tutteli.kbox.impl;

import ch.tutteli.kbox.impl.None;
import ch.tutteli.kbox.impl.Option;
import ch.tutteli.kbox.impl.Some;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b \u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003BQ\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u0012\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00028\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0019\u001a\u00020\nH\u0096\u0002J\t\u0010\u001a\u001a\u00020\nH\u0082\u0010J\u0016\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003H$J\u000e\u0010\u001e\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u001fR\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00028\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030\u000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R \u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u0017j\b\u0012\u0004\u0012\u00028\u0000`\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lch/tutteli/kbox/impl/DynamicTreeTraversalLikeIterator;", "T", "IterableLikeT", "", "initialSequence", "Lkotlin/sequences/Sequence;", "loadElements", "Lkotlin/Function1;", "iteratorProvider", "revisit", "", "dropRoots", "(Lkotlin/sequences/Sequence;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;ZZ)V", "initialIterator", "iteratorsToVisit", "", "getIteratorsToVisit", "()Ljava/util/List;", "getLoadElements", "()Lkotlin/jvm/functions/Function1;", "peek", "Lch/tutteli/kbox/impl/Option;", "visitedElements", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "hasNext", "hasVisitableIterator", "insertIterator", "", "loadedChildrenIterator", "next", "()Ljava/lang/Object;", "kbox"})
@SourceDebugExtension(value={"SMAP\nDynamicTreeTraversal.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DynamicTreeTraversal.kt\nch/tutteli/kbox/impl/DynamicTreeTraversalLikeIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,118:1\n1#2:119\n*E\n"})
public abstract class DynamicTreeTraversalLikeIterator<T, IterableLikeT>
implements Iterator<T>,
KMappedMarker {
    @NotNull
    private final Function1<T, IterableLikeT> loadElements;
    @NotNull
    private final Function1<IterableLikeT, Iterator<T>> iteratorProvider;
    private final boolean revisit;
    private final boolean dropRoots;
    @NotNull
    private final HashSet<T> visitedElements;
    @NotNull
    private final Iterator<T> initialIterator;
    @NotNull
    private final List<Iterator<T>> iteratorsToVisit;
    @NotNull
    private Option<? extends T> peek;

    public DynamicTreeTraversalLikeIterator(@NotNull Sequence<? extends T> initialSequence, @NotNull Function1<? super T, ? extends IterableLikeT> loadElements, @NotNull Function1<? super IterableLikeT, ? extends Iterator<? extends T>> iteratorProvider, boolean revisit, boolean dropRoots) {
        Intrinsics.checkNotNullParameter(initialSequence, (String)"initialSequence");
        Intrinsics.checkNotNullParameter(loadElements, (String)"loadElements");
        Intrinsics.checkNotNullParameter(iteratorProvider, (String)"iteratorProvider");
        this.loadElements = loadElements;
        this.iteratorProvider = iteratorProvider;
        this.revisit = revisit;
        this.dropRoots = dropRoots;
        this.visitedElements = new HashSet();
        this.initialIterator = initialSequence.iterator();
        Object[] objectArray = new Iterator[]{this.initialIterator};
        this.iteratorsToVisit = CollectionsKt.mutableListOf((Object[])objectArray);
        this.peek = None.INSTANCE;
    }

    @NotNull
    protected final Function1<T, IterableLikeT> getLoadElements() {
        return this.loadElements;
    }

    @NotNull
    protected final List<Iterator<T>> getIteratorsToVisit() {
        return this.iteratorsToVisit;
    }

    @Override
    public boolean hasNext() {
        return this.hasVisitableIterator();
    }

    @Override
    public T next() {
        if (!this.hasVisitableIterator()) {
            throw new NoSuchElementException();
        }
        Option<? extends T> p = this.peek;
        if (p instanceof None) {
            throw new IllegalStateException("we just checked hasNext and now we don't have next element, concurrent access? This Iterator is not thread-safe");
        }
        if (!(p instanceof Some)) {
            throw new NoWhenBranchMatchedException();
        }
        this.peek = None.INSTANCE;
        return ((Some)p).getValue();
    }

    private final boolean hasVisitableIterator() {
        boolean bl;
        while (true) {
            if (this.peek instanceof Some) {
                bl = true;
                break;
            }
            if (this.iteratorsToVisit.isEmpty()) {
                bl = false;
                break;
            }
            Iterator<T> firstIterator = this.iteratorsToVisit.get(0);
            if (firstIterator.hasNext()) {
                T element = firstIterator.next();
                if (this.revisit || !this.visitedElements.contains(element)) {
                    this.peek = new Some<T>(element);
                    if (!this.revisit) {
                        this.visitedElements.add(element);
                    }
                    Object object = this.loadElements.invoke(element);
                    object = this.iteratorProvider.invoke(object);
                    Iterator p0 = (Iterator)object;
                    boolean bl2 = false;
                    this.insertIterator(p0);
                    if (this.dropRoots && Intrinsics.areEqual(firstIterator, this.initialIterator)) {
                        this.peek = None.INSTANCE;
                        continue;
                    }
                    bl = true;
                    break;
                }
                this.peek = None.INSTANCE;
                continue;
            }
            this.iteratorsToVisit.remove(0);
        }
        return bl;
    }

    protected abstract void insertIterator(@NotNull Iterator<? extends T> var1);

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }
}

