/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.net;

import ch.qos.logback.access.net.HardenedAccessEventInputStream;
import ch.qos.logback.access.spi.AccessContext;
import ch.qos.logback.access.spi.IAccessEvent;
import ch.qos.logback.core.spi.FilterReply;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;

public class SocketNode
implements Runnable {
    Socket socket;
    AccessContext context;
    HardenedAccessEventInputStream hardenedOIS;

    public SocketNode(Socket socket, AccessContext context) {
        this.socket = socket;
        this.context = context;
        try {
            this.hardenedOIS = new HardenedAccessEventInputStream(new BufferedInputStream(socket.getInputStream()));
        }
        catch (Exception e) {
            System.out.println("Could not open HardenedObjectInputStream to " + String.valueOf(socket) + String.valueOf(e));
        }
    }

    @Override
    public void run() {
        try {
            IAccessEvent event;
            while (this.context.getFilterChainDecision(event = (IAccessEvent)this.hardenedOIS.readObject()) != FilterReply.DENY) {
                this.context.callAppenders(event);
            }
        }
        catch (EOFException e) {
            System.out.println("Caught java.io.EOFException closing connection.");
        }
        catch (SocketException e) {
            System.out.println("Caught java.net.SocketException closing connection.");
        }
        catch (IOException e) {
            System.out.println("Caught java.io.IOException: " + String.valueOf(e));
            System.out.println("Closing connection.");
        }
        catch (Exception e) {
            System.out.println("Unexpected exception. Closing connection." + String.valueOf(e));
        }
        try {
            this.hardenedOIS.close();
        }
        catch (Exception e) {
            System.out.println("Could not close connection." + String.valueOf(e));
        }
    }
}

