/*
 * Decompiled with CFR 0.152.
 */
package scalafix.internal.jgit;

import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Path;
import metaconfig.ConfError$;
import metaconfig.Configured;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.errors.AmbiguousObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.RevisionSyntaxException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.patch.FileHeader;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.io.NullOutputStream;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scalafix.internal.diff.DiffDisable;
import scalafix.internal.diff.DiffDisable$;
import scalafix.internal.diff.GitChange;
import scalafix.internal.diff.ModifiedFile;
import scalafix.internal.diff.NewFile;

public final class JGitDiff$ {
    public static final JGitDiff$ MODULE$ = new JGitDiff$();

    public Configured<DiffDisable> apply(Path workingDir, String diffBase) {
        if (this.isGitRepository(workingDir)) {
            FileRepositoryBuilder builder = new FileRepositoryBuilder();
            Repository repository = ((FileRepositoryBuilder)builder.readEnvironment().setWorkTree(workingDir.toFile())).build();
            Either<String, ObjectId> either = this.resolve(repository, diffBase);
            if (either instanceof Right) {
                Right right = (Right)either;
                ObjectId id = (ObjectId)right.value();
                Either<String, AbstractTreeIterator> either2 = this.iterator(repository, id);
                if (either2 instanceof Right) {
                    Right right2 = (Right)either2;
                    AbstractTreeIterator oldTree = (AbstractTreeIterator)right2.value();
                    FileTreeIterator newTree = new FileTreeIterator(repository);
                    List diffs = this.getDiff(repository, oldTree, (AbstractTreeIterator)newTree).flatMap((Function1 & Serializable)file -> {
                        DiffEntry.ChangeType changeType = file.getChangeType();
                        if (DiffEntry.ChangeType.ADD.equals(changeType)) {
                            return new .colon.colon((Object)new NewFile(JGitDiff$.path$1(file.getNewPath(), workingDir)), (List)Nil$.MODULE$);
                        }
                        if (DiffEntry.ChangeType.MODIFY.equals(changeType)) {
                            return new .colon.colon((Object)JGitDiff$.edits$1(file, workingDir), (List)Nil$.MODULE$);
                        }
                        if (DiffEntry.ChangeType.RENAME.equals(changeType)) {
                            return new .colon.colon((Object)JGitDiff$.edits$1(file, workingDir), (List)Nil$.MODULE$);
                        }
                        if (DiffEntry.ChangeType.COPY.equals(changeType)) {
                            return new .colon.colon((Object)JGitDiff$.edits$1(file, workingDir), (List)Nil$.MODULE$);
                        }
                        if (DiffEntry.ChangeType.DELETE.equals(changeType)) {
                            return Nil$.MODULE$;
                        }
                        throw new MatchError((Object)changeType);
                    });
                    return new Configured.Ok((Object)DiffDisable$.MODULE$.apply(diffs));
                }
                if (either2 instanceof Left) {
                    Left left = (Left)either2;
                    String msg = (String)left.value();
                    return ConfError$.MODULE$.message(msg).notOk();
                }
                throw new MatchError(either2);
            }
            if (either instanceof Left) {
                Left left = (Left)either;
                String msg = (String)left.value();
                return ConfError$.MODULE$.message(msg).notOk();
            }
            throw new MatchError(either);
        }
        return ConfError$.MODULE$.message(new StringBuilder(24).append(workingDir).append(" is not a git repository").toString()).notOk();
    }

    private <T> Left<String, T> unknown(String id) {
        return new Left((Object)new StringBuilder(52).append("'").append(id).append("' unknown revision or path not in the working tree.").toString());
    }

    private Either<String, ObjectId> resolve(Repository repo, String revstr) {
        Right right;
        block6: {
            try {
                Option option = Option$.MODULE$.apply((Object)repo.resolve(revstr));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    ObjectId id = (ObjectId)some.value();
                    right = new Right((Object)id);
                    break block6;
                }
                if (None$.MODULE$.equals(option)) {
                    right = this.unknown(revstr);
                    break block6;
                }
                throw new MatchError((Object)option);
            }
            catch (AmbiguousObjectException ambiguous) {
                String string = new StringBuilder(36).append(revstr).append(" is ambiguous. Possible candidates: ").toString();
                List out = CollectionConverters$.MODULE$.CollectionHasAsScala(ambiguous.getCandidates()).asScala().toList().$colon$colon((Object)string);
                right = new Left((Object)out.mkString(System.lineSeparator()));
            }
            catch (IncorrectObjectTypeException ot) {
                right = new Left((Object)ot.getMessage());
            }
            catch (RevisionSyntaxException st) {
                right = new Left((Object)st.getMessage());
            }
        }
        return right;
    }

    private boolean isGitRepository(Path workingDir) {
        return RepositoryCache.FileKey.isGitRepository((File)workingDir.resolve(".git").toFile(), (FS)FS.DETECTED);
    }

    private Either<String, AbstractTreeIterator> iterator(Repository repository, ObjectId id) {
        Right right;
        try {
            RevWalk walk = new RevWalk(repository);
            RevTree tree = walk.parseTree((AnyObjectId)id);
            CanonicalTreeParser treeParser = new CanonicalTreeParser();
            ObjectReader reader = repository.newObjectReader();
            treeParser.reset(reader, (AnyObjectId)tree.getId());
            walk.dispose();
            right = new Right((Object)treeParser);
        }
        catch (MissingObjectException missingObjectException) {
            right = this.unknown(id.getName());
        }
        return right;
    }

    private List<FileHeader> getDiff(Repository repository, AbstractTreeIterator oldTree, AbstractTreeIterator newTree) {
        DiffFormatter diffFmt = new DiffFormatter((OutputStream)NullOutputStream.INSTANCE);
        diffFmt.setRepository(repository);
        diffFmt.setContext(0);
        diffFmt.setDetectRenames(true);
        java.util.List diffs = diffFmt.scan(oldTree, newTree);
        diffFmt.format(diffs);
        diffFmt.flush();
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(diffs).asScala().map((Function1 & Serializable)diff -> diffFmt.toFileHeader(diff))).toList();
    }

    private static final Path path$1(String relative, Path workingDir$1) {
        return workingDir$1.resolve(relative);
    }

    private static final ModifiedFile edits$1(FileHeader file, Path workingDir$1) {
        Buffer changes = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)file.toEditList()).asScala().map((Function1 & Serializable)edit -> new GitChange(edit.getBeginB(), edit.getEndB()));
        return new ModifiedFile(JGitDiff$.path$1(file.getNewPath(), workingDir$1), changes.toList());
    }

    private JGitDiff$() {
    }
}

