/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v26.group.ORU_R01_OBSERVATION;
import ca.uhn.hl7v2.model.v26.group.ORU_R01_SPECIMEN;
import ca.uhn.hl7v2.model.v26.group.ORU_R01_TIMING_QTY;
import ca.uhn.hl7v2.model.v26.segment.CTD;
import ca.uhn.hl7v2.model.v26.segment.CTI;
import ca.uhn.hl7v2.model.v26.segment.FT1;
import ca.uhn.hl7v2.model.v26.segment.NTE;
import ca.uhn.hl7v2.model.v26.segment.OBR;
import ca.uhn.hl7v2.model.v26.segment.ORC;
import ca.uhn.hl7v2.model.v26.segment.ROL;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class ORU_R01_ORDER_OBSERVATION
extends AbstractGroup {
    public ORU_R01_ORDER_OBSERVATION(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, false, false, false);
            this.add(OBR.class, true, false, false);
            this.add(NTE.class, false, true, false);
            this.add(ROL.class, false, true, false);
            this.add(ORU_R01_TIMING_QTY.class, false, true, false);
            this.add(CTD.class, false, false, false);
            this.add(ORU_R01_OBSERVATION.class, false, true, false);
            this.add(FT1.class, false, true, false);
            this.add(CTI.class, false, true, false);
            this.add(ORU_R01_SPECIMEN.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ORU_R01_ORDER_OBSERVATION - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public ORC getORC() {
        ORC retVal = (ORC)this.getTyped("ORC", ORC.class);
        return retVal;
    }

    public OBR getOBR() {
        OBR retVal = (OBR)this.getTyped("OBR", OBR.class);
        return retVal;
    }

    public NTE getNTE() {
        NTE retVal = (NTE)this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = (NTE)this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public ROL getROL() {
        ROL retVal = (ROL)this.getTyped("ROL", ROL.class);
        return retVal;
    }

    public ROL getROL(int rep) {
        ROL retVal = (ROL)this.getTyped("ROL", rep, ROL.class);
        return retVal;
    }

    public int getROLReps() {
        return this.getReps("ROL");
    }

    public List<ROL> getROLAll() throws HL7Exception {
        return this.getAllAsList("ROL", ROL.class);
    }

    public void insertROL(ROL structure, int rep) throws HL7Exception {
        super.insertRepetition("ROL", (Structure)structure, rep);
    }

    public ROL insertROL(int rep) throws HL7Exception {
        return (ROL)super.insertRepetition("ROL", rep);
    }

    public ROL removeROL(int rep) throws HL7Exception {
        return (ROL)super.removeRepetition("ROL", rep);
    }

    public ORU_R01_TIMING_QTY getTIMING_QTY() {
        ORU_R01_TIMING_QTY retVal = (ORU_R01_TIMING_QTY)this.getTyped("TIMING_QTY", ORU_R01_TIMING_QTY.class);
        return retVal;
    }

    public ORU_R01_TIMING_QTY getTIMING_QTY(int rep) {
        ORU_R01_TIMING_QTY retVal = (ORU_R01_TIMING_QTY)this.getTyped("TIMING_QTY", rep, ORU_R01_TIMING_QTY.class);
        return retVal;
    }

    public int getTIMING_QTYReps() {
        return this.getReps("TIMING_QTY");
    }

    public List<ORU_R01_TIMING_QTY> getTIMING_QTYAll() throws HL7Exception {
        return this.getAllAsList("TIMING_QTY", ORU_R01_TIMING_QTY.class);
    }

    public void insertTIMING_QTY(ORU_R01_TIMING_QTY structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING_QTY", (Structure)structure, rep);
    }

    public ORU_R01_TIMING_QTY insertTIMING_QTY(int rep) throws HL7Exception {
        return (ORU_R01_TIMING_QTY)super.insertRepetition("TIMING_QTY", rep);
    }

    public ORU_R01_TIMING_QTY removeTIMING_QTY(int rep) throws HL7Exception {
        return (ORU_R01_TIMING_QTY)super.removeRepetition("TIMING_QTY", rep);
    }

    public CTD getCTD() {
        CTD retVal = (CTD)this.getTyped("CTD", CTD.class);
        return retVal;
    }

    public ORU_R01_OBSERVATION getOBSERVATION() {
        ORU_R01_OBSERVATION retVal = (ORU_R01_OBSERVATION)this.getTyped("OBSERVATION", ORU_R01_OBSERVATION.class);
        return retVal;
    }

    public ORU_R01_OBSERVATION getOBSERVATION(int rep) {
        ORU_R01_OBSERVATION retVal = (ORU_R01_OBSERVATION)this.getTyped("OBSERVATION", rep, ORU_R01_OBSERVATION.class);
        return retVal;
    }

    public int getOBSERVATIONReps() {
        return this.getReps("OBSERVATION");
    }

    public List<ORU_R01_OBSERVATION> getOBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("OBSERVATION", ORU_R01_OBSERVATION.class);
    }

    public void insertOBSERVATION(ORU_R01_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATION", (Structure)structure, rep);
    }

    public ORU_R01_OBSERVATION insertOBSERVATION(int rep) throws HL7Exception {
        return (ORU_R01_OBSERVATION)super.insertRepetition("OBSERVATION", rep);
    }

    public ORU_R01_OBSERVATION removeOBSERVATION(int rep) throws HL7Exception {
        return (ORU_R01_OBSERVATION)super.removeRepetition("OBSERVATION", rep);
    }

    public FT1 getFT1() {
        FT1 retVal = (FT1)this.getTyped("FT1", FT1.class);
        return retVal;
    }

    public FT1 getFT1(int rep) {
        FT1 retVal = (FT1)this.getTyped("FT1", rep, FT1.class);
        return retVal;
    }

    public int getFT1Reps() {
        return this.getReps("FT1");
    }

    public List<FT1> getFT1All() throws HL7Exception {
        return this.getAllAsList("FT1", FT1.class);
    }

    public void insertFT1(FT1 structure, int rep) throws HL7Exception {
        super.insertRepetition("FT1", (Structure)structure, rep);
    }

    public FT1 insertFT1(int rep) throws HL7Exception {
        return (FT1)super.insertRepetition("FT1", rep);
    }

    public FT1 removeFT1(int rep) throws HL7Exception {
        return (FT1)super.removeRepetition("FT1", rep);
    }

    public CTI getCTI() {
        CTI retVal = (CTI)this.getTyped("CTI", CTI.class);
        return retVal;
    }

    public CTI getCTI(int rep) {
        CTI retVal = (CTI)this.getTyped("CTI", rep, CTI.class);
        return retVal;
    }

    public int getCTIReps() {
        return this.getReps("CTI");
    }

    public List<CTI> getCTIAll() throws HL7Exception {
        return this.getAllAsList("CTI", CTI.class);
    }

    public void insertCTI(CTI structure, int rep) throws HL7Exception {
        super.insertRepetition("CTI", (Structure)structure, rep);
    }

    public CTI insertCTI(int rep) throws HL7Exception {
        return (CTI)super.insertRepetition("CTI", rep);
    }

    public CTI removeCTI(int rep) throws HL7Exception {
        return (CTI)super.removeRepetition("CTI", rep);
    }

    public ORU_R01_SPECIMEN getSPECIMEN() {
        ORU_R01_SPECIMEN retVal = (ORU_R01_SPECIMEN)this.getTyped("SPECIMEN", ORU_R01_SPECIMEN.class);
        return retVal;
    }

    public ORU_R01_SPECIMEN getSPECIMEN(int rep) {
        ORU_R01_SPECIMEN retVal = (ORU_R01_SPECIMEN)this.getTyped("SPECIMEN", rep, ORU_R01_SPECIMEN.class);
        return retVal;
    }

    public int getSPECIMENReps() {
        return this.getReps("SPECIMEN");
    }

    public List<ORU_R01_SPECIMEN> getSPECIMENAll() throws HL7Exception {
        return this.getAllAsList("SPECIMEN", ORU_R01_SPECIMEN.class);
    }

    public void insertSPECIMEN(ORU_R01_SPECIMEN structure, int rep) throws HL7Exception {
        super.insertRepetition("SPECIMEN", (Structure)structure, rep);
    }

    public ORU_R01_SPECIMEN insertSPECIMEN(int rep) throws HL7Exception {
        return (ORU_R01_SPECIMEN)super.insertRepetition("SPECIMEN", rep);
    }

    public ORU_R01_SPECIMEN removeSPECIMEN(int rep) throws HL7Exception {
        return (ORU_R01_SPECIMEN)super.removeRepetition("SPECIMEN", rep);
    }
}

