/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v251.group.RSP_Z86_ADMINISTRATION;
import ca.uhn.hl7v2.model.v251.group.RSP_Z86_DISPENSE;
import ca.uhn.hl7v2.model.v251.group.RSP_Z86_ENCODED_ORDER;
import ca.uhn.hl7v2.model.v251.group.RSP_Z86_GIVE;
import ca.uhn.hl7v2.model.v251.group.RSP_Z86_OBSERVATION;
import ca.uhn.hl7v2.model.v251.group.RSP_Z86_ORDER_DETAIL;
import ca.uhn.hl7v2.model.v251.group.RSP_Z86_TIMING;
import ca.uhn.hl7v2.model.v251.segment.ORC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class RSP_Z86_COMMON_ORDER
extends AbstractGroup {
    public RSP_Z86_COMMON_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false, false);
            this.add(RSP_Z86_TIMING.class, false, true, false);
            this.add(RSP_Z86_ORDER_DETAIL.class, false, false, false);
            this.add(RSP_Z86_ENCODED_ORDER.class, false, false, false);
            this.add(RSP_Z86_DISPENSE.class, false, false, false);
            this.add(RSP_Z86_GIVE.class, false, false, false);
            this.add(RSP_Z86_ADMINISTRATION.class, false, false, false);
            this.add(RSP_Z86_OBSERVATION.class, true, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RSP_Z86_COMMON_ORDER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public ORC getORC() {
        ORC retVal = (ORC)this.getTyped("ORC", ORC.class);
        return retVal;
    }

    public RSP_Z86_TIMING getTIMING() {
        RSP_Z86_TIMING retVal = (RSP_Z86_TIMING)this.getTyped("TIMING", RSP_Z86_TIMING.class);
        return retVal;
    }

    public RSP_Z86_TIMING getTIMING(int rep) {
        RSP_Z86_TIMING retVal = (RSP_Z86_TIMING)this.getTyped("TIMING", rep, RSP_Z86_TIMING.class);
        return retVal;
    }

    public int getTIMINGReps() {
        return this.getReps("TIMING");
    }

    public List<RSP_Z86_TIMING> getTIMINGAll() throws HL7Exception {
        return this.getAllAsList("TIMING", RSP_Z86_TIMING.class);
    }

    public void insertTIMING(RSP_Z86_TIMING structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING", (Structure)structure, rep);
    }

    public RSP_Z86_TIMING insertTIMING(int rep) throws HL7Exception {
        return (RSP_Z86_TIMING)super.insertRepetition("TIMING", rep);
    }

    public RSP_Z86_TIMING removeTIMING(int rep) throws HL7Exception {
        return (RSP_Z86_TIMING)super.removeRepetition("TIMING", rep);
    }

    public RSP_Z86_ORDER_DETAIL getORDER_DETAIL() {
        RSP_Z86_ORDER_DETAIL retVal = (RSP_Z86_ORDER_DETAIL)this.getTyped("ORDER_DETAIL", RSP_Z86_ORDER_DETAIL.class);
        return retVal;
    }

    public RSP_Z86_ENCODED_ORDER getENCODED_ORDER() {
        RSP_Z86_ENCODED_ORDER retVal = (RSP_Z86_ENCODED_ORDER)this.getTyped("ENCODED_ORDER", RSP_Z86_ENCODED_ORDER.class);
        return retVal;
    }

    public RSP_Z86_DISPENSE getDISPENSE() {
        RSP_Z86_DISPENSE retVal = (RSP_Z86_DISPENSE)this.getTyped("DISPENSE", RSP_Z86_DISPENSE.class);
        return retVal;
    }

    public RSP_Z86_GIVE getGIVE() {
        RSP_Z86_GIVE retVal = (RSP_Z86_GIVE)this.getTyped("GIVE", RSP_Z86_GIVE.class);
        return retVal;
    }

    public RSP_Z86_ADMINISTRATION getADMINISTRATION() {
        RSP_Z86_ADMINISTRATION retVal = (RSP_Z86_ADMINISTRATION)this.getTyped("ADMINISTRATION", RSP_Z86_ADMINISTRATION.class);
        return retVal;
    }

    public RSP_Z86_OBSERVATION getOBSERVATION() {
        RSP_Z86_OBSERVATION retVal = (RSP_Z86_OBSERVATION)this.getTyped("OBSERVATION", RSP_Z86_OBSERVATION.class);
        return retVal;
    }

    public RSP_Z86_OBSERVATION getOBSERVATION(int rep) {
        RSP_Z86_OBSERVATION retVal = (RSP_Z86_OBSERVATION)this.getTyped("OBSERVATION", rep, RSP_Z86_OBSERVATION.class);
        return retVal;
    }

    public int getOBSERVATIONReps() {
        return this.getReps("OBSERVATION");
    }

    public List<RSP_Z86_OBSERVATION> getOBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("OBSERVATION", RSP_Z86_OBSERVATION.class);
    }

    public void insertOBSERVATION(RSP_Z86_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATION", (Structure)structure, rep);
    }

    public RSP_Z86_OBSERVATION insertOBSERVATION(int rep) throws HL7Exception {
        return (RSP_Z86_OBSERVATION)super.insertRepetition("OBSERVATION", rep);
    }

    public RSP_Z86_OBSERVATION removeOBSERVATION(int rep) throws HL7Exception {
        return (RSP_Z86_OBSERVATION)super.removeRepetition("OBSERVATION", rep);
    }
}

