/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v25.segment.NTE;
import ca.uhn.hl7v2.model.v25.segment.OBX;
import ca.uhn.hl7v2.model.v25.segment.SID;
import ca.uhn.hl7v2.model.v25.segment.TCD;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class OUL_R24_RESULT
extends AbstractGroup {
    public OUL_R24_RESULT(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(OBX.class, true, false, false);
            this.add(TCD.class, false, false, false);
            this.add(SID.class, false, true, false);
            this.add(NTE.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OUL_R24_RESULT - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public OBX getOBX() {
        OBX retVal = (OBX)this.getTyped("OBX", OBX.class);
        return retVal;
    }

    public TCD getTCD() {
        TCD retVal = (TCD)this.getTyped("TCD", TCD.class);
        return retVal;
    }

    public SID getSID() {
        SID retVal = (SID)this.getTyped("SID", SID.class);
        return retVal;
    }

    public SID getSID(int rep) {
        SID retVal = (SID)this.getTyped("SID", rep, SID.class);
        return retVal;
    }

    public int getSIDReps() {
        return this.getReps("SID");
    }

    public List<SID> getSIDAll() throws HL7Exception {
        return this.getAllAsList("SID", SID.class);
    }

    public void insertSID(SID structure, int rep) throws HL7Exception {
        super.insertRepetition("SID", (Structure)structure, rep);
    }

    public SID insertSID(int rep) throws HL7Exception {
        return (SID)super.insertRepetition("SID", rep);
    }

    public SID removeSID(int rep) throws HL7Exception {
        return (SID)super.removeRepetition("SID", rep);
    }

    public NTE getNTE() {
        NTE retVal = (NTE)this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = (NTE)this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }
}

