/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v24.datatype.CE;
import ca.uhn.hl7v2.model.v24.datatype.CQ;
import ca.uhn.hl7v2.model.v24.datatype.ID;
import ca.uhn.hl7v2.model.v24.datatype.LA1;
import ca.uhn.hl7v2.model.v24.datatype.NM;
import ca.uhn.hl7v2.model.v24.datatype.ST;
import ca.uhn.hl7v2.model.v24.datatype.TQ;
import ca.uhn.hl7v2.model.v24.datatype.TS;
import ca.uhn.hl7v2.model.v24.datatype.XCN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class RXE
extends AbstractSegment {
    public RXE(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(TQ.class, true, 1, 200, new Object[]{this.getMessage()}, "Quantity/Timing");
            this.add(CE.class, true, 1, 250, new Object[]{this.getMessage()}, "Give Code");
            this.add(NM.class, true, 1, 20, new Object[]{this.getMessage()}, "Give Amount - Minimum");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Give Amount - Maximum");
            this.add(CE.class, true, 1, 250, new Object[]{this.getMessage()}, "Give Units");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Give Dosage Form");
            this.add(CE.class, false, 0, 250, new Object[]{this.getMessage()}, "Provider's Administration Instructions");
            this.add(LA1.class, false, 1, 200, new Object[]{this.getMessage()}, "Deliver-To Location");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(167)}, "Substitution Status");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Dispense Amount");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Dispense Units");
            this.add(NM.class, false, 1, 3, new Object[]{this.getMessage()}, "Number of Refills");
            this.add(XCN.class, false, 0, 250, new Object[]{this.getMessage()}, "Ordering Provider's DEA Number");
            this.add(XCN.class, false, 0, 250, new Object[]{this.getMessage()}, "Pharmacist/Treatment Supplier's Verifier ID");
            this.add(ST.class, false, 1, 20, new Object[]{this.getMessage()}, "Prescription Number");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Number of Refills Remaining");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Number of Refills/Doses Dispensed");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "D/T of Most Recent Refill or Dose Dispensed");
            this.add(CQ.class, false, 1, 10, new Object[]{this.getMessage()}, "Total Daily Dose");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Needs Human Review");
            this.add(CE.class, false, 0, 250, new Object[]{this.getMessage()}, "Pharmacy/Treatment Supplier's Special Dispensing Instructions");
            this.add(ST.class, false, 1, 20, new Object[]{this.getMessage()}, "Give Per (Time Unit)");
            this.add(ST.class, false, 1, 6, new Object[]{this.getMessage()}, "Give Rate Amount");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Give Rate Units");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Give Strength");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Give Strength Units");
            this.add(CE.class, false, 0, 250, new Object[]{this.getMessage()}, "Give Indication");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Dispense Package Size");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Dispense Package Size Unit");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(321)}, "Dispense Package Method");
            this.add(CE.class, false, 0, 250, new Object[]{this.getMessage()}, "Supplementary Code");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RXE - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public TQ getQuantityTiming() {
        TQ retVal = (TQ)this.getTypedField(1, 0);
        return retVal;
    }

    public TQ getRxe1_QuantityTiming() {
        TQ retVal = (TQ)this.getTypedField(1, 0);
        return retVal;
    }

    public CE getGiveCode() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getRxe2_GiveCode() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public NM getGiveAmountMinimum() {
        NM retVal = (NM)this.getTypedField(3, 0);
        return retVal;
    }

    public NM getRxe3_GiveAmountMinimum() {
        NM retVal = (NM)this.getTypedField(3, 0);
        return retVal;
    }

    public NM getGiveAmountMaximum() {
        NM retVal = (NM)this.getTypedField(4, 0);
        return retVal;
    }

    public NM getRxe4_GiveAmountMaximum() {
        NM retVal = (NM)this.getTypedField(4, 0);
        return retVal;
    }

    public CE getGiveUnits() {
        CE retVal = (CE)this.getTypedField(5, 0);
        return retVal;
    }

    public CE getRxe5_GiveUnits() {
        CE retVal = (CE)this.getTypedField(5, 0);
        return retVal;
    }

    public CE getGiveDosageForm() {
        CE retVal = (CE)this.getTypedField(6, 0);
        return retVal;
    }

    public CE getRxe6_GiveDosageForm() {
        CE retVal = (CE)this.getTypedField(6, 0);
        return retVal;
    }

    public CE[] getProviderSAdministrationInstructions() {
        CE[] retVal = (CE[])this.getTypedField(7, (Type[])new CE[0]);
        return retVal;
    }

    public CE[] getRxe7_ProviderSAdministrationInstructions() {
        CE[] retVal = (CE[])this.getTypedField(7, (Type[])new CE[0]);
        return retVal;
    }

    public int getProviderSAdministrationInstructionsReps() {
        return this.getReps(7);
    }

    public CE getProviderSAdministrationInstructions(int rep) {
        CE retVal = (CE)this.getTypedField(7, rep);
        return retVal;
    }

    public CE getRxe7_ProviderSAdministrationInstructions(int rep) {
        CE retVal = (CE)this.getTypedField(7, rep);
        return retVal;
    }

    public int getRxe7_ProviderSAdministrationInstructionsReps() {
        return this.getReps(7);
    }

    public CE insertProviderSAdministrationInstructions(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(7, rep);
    }

    public CE insertRxe7_ProviderSAdministrationInstructions(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(7, rep);
    }

    public CE removeProviderSAdministrationInstructions(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(7, rep);
    }

    public CE removeRxe7_ProviderSAdministrationInstructions(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(7, rep);
    }

    public LA1 getDeliverToLocation() {
        LA1 retVal = (LA1)this.getTypedField(8, 0);
        return retVal;
    }

    public LA1 getRxe8_DeliverToLocation() {
        LA1 retVal = (LA1)this.getTypedField(8, 0);
        return retVal;
    }

    public ID getSubstitutionStatus() {
        ID retVal = (ID)this.getTypedField(9, 0);
        return retVal;
    }

    public ID getRxe9_SubstitutionStatus() {
        ID retVal = (ID)this.getTypedField(9, 0);
        return retVal;
    }

    public NM getDispenseAmount() {
        NM retVal = (NM)this.getTypedField(10, 0);
        return retVal;
    }

    public NM getRxe10_DispenseAmount() {
        NM retVal = (NM)this.getTypedField(10, 0);
        return retVal;
    }

    public CE getDispenseUnits() {
        CE retVal = (CE)this.getTypedField(11, 0);
        return retVal;
    }

    public CE getRxe11_DispenseUnits() {
        CE retVal = (CE)this.getTypedField(11, 0);
        return retVal;
    }

    public NM getNumberOfRefills() {
        NM retVal = (NM)this.getTypedField(12, 0);
        return retVal;
    }

    public NM getRxe12_NumberOfRefills() {
        NM retVal = (NM)this.getTypedField(12, 0);
        return retVal;
    }

    public XCN[] getOrderingProviderSDEANumber() {
        XCN[] retVal = (XCN[])this.getTypedField(13, (Type[])new XCN[0]);
        return retVal;
    }

    public XCN[] getRxe13_OrderingProviderSDEANumber() {
        XCN[] retVal = (XCN[])this.getTypedField(13, (Type[])new XCN[0]);
        return retVal;
    }

    public int getOrderingProviderSDEANumberReps() {
        return this.getReps(13);
    }

    public XCN getOrderingProviderSDEANumber(int rep) {
        XCN retVal = (XCN)this.getTypedField(13, rep);
        return retVal;
    }

    public XCN getRxe13_OrderingProviderSDEANumber(int rep) {
        XCN retVal = (XCN)this.getTypedField(13, rep);
        return retVal;
    }

    public int getRxe13_OrderingProviderSDEANumberReps() {
        return this.getReps(13);
    }

    public XCN insertOrderingProviderSDEANumber(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(13, rep);
    }

    public XCN insertRxe13_OrderingProviderSDEANumber(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(13, rep);
    }

    public XCN removeOrderingProviderSDEANumber(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(13, rep);
    }

    public XCN removeRxe13_OrderingProviderSDEANumber(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(13, rep);
    }

    public XCN[] getPharmacistTreatmentSupplierSVerifierID() {
        XCN[] retVal = (XCN[])this.getTypedField(14, (Type[])new XCN[0]);
        return retVal;
    }

    public XCN[] getRxe14_PharmacistTreatmentSupplierSVerifierID() {
        XCN[] retVal = (XCN[])this.getTypedField(14, (Type[])new XCN[0]);
        return retVal;
    }

    public int getPharmacistTreatmentSupplierSVerifierIDReps() {
        return this.getReps(14);
    }

    public XCN getPharmacistTreatmentSupplierSVerifierID(int rep) {
        XCN retVal = (XCN)this.getTypedField(14, rep);
        return retVal;
    }

    public XCN getRxe14_PharmacistTreatmentSupplierSVerifierID(int rep) {
        XCN retVal = (XCN)this.getTypedField(14, rep);
        return retVal;
    }

    public int getRxe14_PharmacistTreatmentSupplierSVerifierIDReps() {
        return this.getReps(14);
    }

    public XCN insertPharmacistTreatmentSupplierSVerifierID(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(14, rep);
    }

    public XCN insertRxe14_PharmacistTreatmentSupplierSVerifierID(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(14, rep);
    }

    public XCN removePharmacistTreatmentSupplierSVerifierID(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(14, rep);
    }

    public XCN removeRxe14_PharmacistTreatmentSupplierSVerifierID(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(14, rep);
    }

    public ST getPrescriptionNumber() {
        ST retVal = (ST)this.getTypedField(15, 0);
        return retVal;
    }

    public ST getRxe15_PrescriptionNumber() {
        ST retVal = (ST)this.getTypedField(15, 0);
        return retVal;
    }

    public NM getNumberOfRefillsRemaining() {
        NM retVal = (NM)this.getTypedField(16, 0);
        return retVal;
    }

    public NM getRxe16_NumberOfRefillsRemaining() {
        NM retVal = (NM)this.getTypedField(16, 0);
        return retVal;
    }

    public NM getNumberOfRefillsDosesDispensed() {
        NM retVal = (NM)this.getTypedField(17, 0);
        return retVal;
    }

    public NM getRxe17_NumberOfRefillsDosesDispensed() {
        NM retVal = (NM)this.getTypedField(17, 0);
        return retVal;
    }

    public TS getDTOfMostRecentRefillOrDoseDispensed() {
        TS retVal = (TS)this.getTypedField(18, 0);
        return retVal;
    }

    public TS getRxe18_DTOfMostRecentRefillOrDoseDispensed() {
        TS retVal = (TS)this.getTypedField(18, 0);
        return retVal;
    }

    public CQ getTotalDailyDose() {
        CQ retVal = (CQ)this.getTypedField(19, 0);
        return retVal;
    }

    public CQ getRxe19_TotalDailyDose() {
        CQ retVal = (CQ)this.getTypedField(19, 0);
        return retVal;
    }

    public ID getNeedsHumanReview() {
        ID retVal = (ID)this.getTypedField(20, 0);
        return retVal;
    }

    public ID getRxe20_NeedsHumanReview() {
        ID retVal = (ID)this.getTypedField(20, 0);
        return retVal;
    }

    public CE[] getPharmacyTreatmentSupplierSSpecialDispensingInstructions() {
        CE[] retVal = (CE[])this.getTypedField(21, (Type[])new CE[0]);
        return retVal;
    }

    public CE[] getRxe21_PharmacyTreatmentSupplierSSpecialDispensingInstructions() {
        CE[] retVal = (CE[])this.getTypedField(21, (Type[])new CE[0]);
        return retVal;
    }

    public int getPharmacyTreatmentSupplierSSpecialDispensingInstructionsReps() {
        return this.getReps(21);
    }

    public CE getPharmacyTreatmentSupplierSSpecialDispensingInstructions(int rep) {
        CE retVal = (CE)this.getTypedField(21, rep);
        return retVal;
    }

    public CE getRxe21_PharmacyTreatmentSupplierSSpecialDispensingInstructions(int rep) {
        CE retVal = (CE)this.getTypedField(21, rep);
        return retVal;
    }

    public int getRxe21_PharmacyTreatmentSupplierSSpecialDispensingInstructionsReps() {
        return this.getReps(21);
    }

    public CE insertPharmacyTreatmentSupplierSSpecialDispensingInstructions(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(21, rep);
    }

    public CE insertRxe21_PharmacyTreatmentSupplierSSpecialDispensingInstructions(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(21, rep);
    }

    public CE removePharmacyTreatmentSupplierSSpecialDispensingInstructions(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(21, rep);
    }

    public CE removeRxe21_PharmacyTreatmentSupplierSSpecialDispensingInstructions(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(21, rep);
    }

    public ST getGivePerTimeUnit() {
        ST retVal = (ST)this.getTypedField(22, 0);
        return retVal;
    }

    public ST getRxe22_GivePerTimeUnit() {
        ST retVal = (ST)this.getTypedField(22, 0);
        return retVal;
    }

    public ST getGiveRateAmount() {
        ST retVal = (ST)this.getTypedField(23, 0);
        return retVal;
    }

    public ST getRxe23_GiveRateAmount() {
        ST retVal = (ST)this.getTypedField(23, 0);
        return retVal;
    }

    public CE getGiveRateUnits() {
        CE retVal = (CE)this.getTypedField(24, 0);
        return retVal;
    }

    public CE getRxe24_GiveRateUnits() {
        CE retVal = (CE)this.getTypedField(24, 0);
        return retVal;
    }

    public NM getGiveStrength() {
        NM retVal = (NM)this.getTypedField(25, 0);
        return retVal;
    }

    public NM getRxe25_GiveStrength() {
        NM retVal = (NM)this.getTypedField(25, 0);
        return retVal;
    }

    public CE getGiveStrengthUnits() {
        CE retVal = (CE)this.getTypedField(26, 0);
        return retVal;
    }

    public CE getRxe26_GiveStrengthUnits() {
        CE retVal = (CE)this.getTypedField(26, 0);
        return retVal;
    }

    public CE[] getGiveIndication() {
        CE[] retVal = (CE[])this.getTypedField(27, (Type[])new CE[0]);
        return retVal;
    }

    public CE[] getRxe27_GiveIndication() {
        CE[] retVal = (CE[])this.getTypedField(27, (Type[])new CE[0]);
        return retVal;
    }

    public int getGiveIndicationReps() {
        return this.getReps(27);
    }

    public CE getGiveIndication(int rep) {
        CE retVal = (CE)this.getTypedField(27, rep);
        return retVal;
    }

    public CE getRxe27_GiveIndication(int rep) {
        CE retVal = (CE)this.getTypedField(27, rep);
        return retVal;
    }

    public int getRxe27_GiveIndicationReps() {
        return this.getReps(27);
    }

    public CE insertGiveIndication(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(27, rep);
    }

    public CE insertRxe27_GiveIndication(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(27, rep);
    }

    public CE removeGiveIndication(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(27, rep);
    }

    public CE removeRxe27_GiveIndication(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(27, rep);
    }

    public NM getDispensePackageSize() {
        NM retVal = (NM)this.getTypedField(28, 0);
        return retVal;
    }

    public NM getRxe28_DispensePackageSize() {
        NM retVal = (NM)this.getTypedField(28, 0);
        return retVal;
    }

    public CE getDispensePackageSizeUnit() {
        CE retVal = (CE)this.getTypedField(29, 0);
        return retVal;
    }

    public CE getRxe29_DispensePackageSizeUnit() {
        CE retVal = (CE)this.getTypedField(29, 0);
        return retVal;
    }

    public ID getDispensePackageMethod() {
        ID retVal = (ID)this.getTypedField(30, 0);
        return retVal;
    }

    public ID getRxe30_DispensePackageMethod() {
        ID retVal = (ID)this.getTypedField(30, 0);
        return retVal;
    }

    public CE[] getSupplementaryCode() {
        CE[] retVal = (CE[])this.getTypedField(31, (Type[])new CE[0]);
        return retVal;
    }

    public CE[] getRxe31_SupplementaryCode() {
        CE[] retVal = (CE[])this.getTypedField(31, (Type[])new CE[0]);
        return retVal;
    }

    public int getSupplementaryCodeReps() {
        return this.getReps(31);
    }

    public CE getSupplementaryCode(int rep) {
        CE retVal = (CE)this.getTypedField(31, rep);
        return retVal;
    }

    public CE getRxe31_SupplementaryCode(int rep) {
        CE retVal = (CE)this.getTypedField(31, rep);
        return retVal;
    }

    public int getRxe31_SupplementaryCodeReps() {
        return this.getReps(31);
    }

    public CE insertSupplementaryCode(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(31, rep);
    }

    public CE insertRxe31_SupplementaryCode(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(31, rep);
    }

    public CE removeSupplementaryCode(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(31, rep);
    }

    public CE removeRxe31_SupplementaryCode(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(31, rep);
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new TQ(this.getMessage());
            }
            case 1: {
                return new CE(this.getMessage());
            }
            case 2: {
                return new NM(this.getMessage());
            }
            case 3: {
                return new NM(this.getMessage());
            }
            case 4: {
                return new CE(this.getMessage());
            }
            case 5: {
                return new CE(this.getMessage());
            }
            case 6: {
                return new CE(this.getMessage());
            }
            case 7: {
                return new LA1(this.getMessage());
            }
            case 8: {
                return new ID(this.getMessage(), new Integer(167));
            }
            case 9: {
                return new NM(this.getMessage());
            }
            case 10: {
                return new CE(this.getMessage());
            }
            case 11: {
                return new NM(this.getMessage());
            }
            case 12: {
                return new XCN(this.getMessage());
            }
            case 13: {
                return new XCN(this.getMessage());
            }
            case 14: {
                return new ST(this.getMessage());
            }
            case 15: {
                return new NM(this.getMessage());
            }
            case 16: {
                return new NM(this.getMessage());
            }
            case 17: {
                return new TS(this.getMessage());
            }
            case 18: {
                return new CQ(this.getMessage());
            }
            case 19: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 20: {
                return new CE(this.getMessage());
            }
            case 21: {
                return new ST(this.getMessage());
            }
            case 22: {
                return new ST(this.getMessage());
            }
            case 23: {
                return new CE(this.getMessage());
            }
            case 24: {
                return new NM(this.getMessage());
            }
            case 25: {
                return new CE(this.getMessage());
            }
            case 26: {
                return new CE(this.getMessage());
            }
            case 27: {
                return new NM(this.getMessage());
            }
            case 28: {
                return new CE(this.getMessage());
            }
            case 29: {
                return new ID(this.getMessage(), new Integer(321));
            }
            case 30: {
                return new CE(this.getMessage());
            }
        }
        return null;
    }
}

