/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v24.group.RPR_I03_PROVIDER;
import ca.uhn.hl7v2.model.v24.segment.MSA;
import ca.uhn.hl7v2.model.v24.segment.MSH;
import ca.uhn.hl7v2.model.v24.segment.NTE;
import ca.uhn.hl7v2.model.v24.segment.PID;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class RPR_I03
extends AbstractMessage {
    public RPR_I03() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public RPR_I03(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(MSA.class, true, false);
            this.add(RPR_I03_PROVIDER.class, true, true);
            this.add(PID.class, false, true);
            this.add(NTE.class, false, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RPR_I03 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.4";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public MSA getMSA() {
        return (MSA)this.getTyped("MSA", MSA.class);
    }

    public RPR_I03_PROVIDER getPROVIDER() {
        return (RPR_I03_PROVIDER)this.getTyped("PROVIDER", RPR_I03_PROVIDER.class);
    }

    public RPR_I03_PROVIDER getPROVIDER(int rep) {
        return (RPR_I03_PROVIDER)this.getTyped("PROVIDER", rep, RPR_I03_PROVIDER.class);
    }

    public int getPROVIDERReps() {
        return this.getReps("PROVIDER");
    }

    public List<RPR_I03_PROVIDER> getPROVIDERAll() throws HL7Exception {
        return this.getAllAsList("PROVIDER", RPR_I03_PROVIDER.class);
    }

    public void insertPROVIDER(RPR_I03_PROVIDER structure, int rep) throws HL7Exception {
        super.insertRepetition("PROVIDER", (Structure)structure, rep);
    }

    public RPR_I03_PROVIDER insertPROVIDER(int rep) throws HL7Exception {
        return (RPR_I03_PROVIDER)super.insertRepetition("PROVIDER", rep);
    }

    public RPR_I03_PROVIDER removePROVIDER(int rep) throws HL7Exception {
        return (RPR_I03_PROVIDER)super.removeRepetition("PROVIDER", rep);
    }

    public PID getPID() {
        return (PID)this.getTyped("PID", PID.class);
    }

    public PID getPID(int rep) {
        return (PID)this.getTyped("PID", rep, PID.class);
    }

    public int getPIDReps() {
        return this.getReps("PID");
    }

    public List<PID> getPIDAll() throws HL7Exception {
        return this.getAllAsList("PID", PID.class);
    }

    public void insertPID(PID structure, int rep) throws HL7Exception {
        super.insertRepetition("PID", (Structure)structure, rep);
    }

    public PID insertPID(int rep) throws HL7Exception {
        return (PID)super.insertRepetition("PID", rep);
    }

    public PID removePID(int rep) throws HL7Exception {
        return (PID)super.removeRepetition("PID", rep);
    }

    public NTE getNTE() {
        return (NTE)this.getTyped("NTE", NTE.class);
    }

    public NTE getNTE(int rep) {
        return (NTE)this.getTyped("NTE", rep, NTE.class);
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }
}

