/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.datatype;

import ca.uhn.hl7v2.model.AbstractComposite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v24.datatype.FN;
import ca.uhn.hl7v2.model.v24.datatype.HD;
import ca.uhn.hl7v2.model.v24.datatype.IS;
import ca.uhn.hl7v2.model.v24.datatype.ST;

public class CN
extends AbstractComposite {
    private Type[] data;

    public CN(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[9];
        this.data[0] = new ST(this.getMessage());
        this.data[1] = new FN(this.getMessage());
        this.data[2] = new ST(this.getMessage());
        this.data[3] = new ST(this.getMessage());
        this.data[4] = new ST(this.getMessage());
        this.data[5] = new ST(this.getMessage());
        this.data[6] = new IS(this.getMessage(), 0);
        this.data[7] = new IS(this.getMessage(), 0);
        this.data[8] = new HD(this.getMessage());
    }

    public Type[] getComponents() {
        return this.data;
    }

    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + ((Object)((Object)this)).getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public ST getIDNumber() {
        return (ST)this.getTyped(0, ST.class);
    }

    public ST getCn1_IDNumber() {
        return (ST)this.getTyped(0, ST.class);
    }

    public FN getFamilyName() {
        return (FN)this.getTyped(1, FN.class);
    }

    public FN getCn2_FamilyName() {
        return (FN)this.getTyped(1, FN.class);
    }

    public ST getGivenName() {
        return (ST)this.getTyped(2, ST.class);
    }

    public ST getCn3_GivenName() {
        return (ST)this.getTyped(2, ST.class);
    }

    public ST getSecondAndFurtherGivenNamesOrInitialsThereof() {
        return (ST)this.getTyped(3, ST.class);
    }

    public ST getCn4_SecondAndFurtherGivenNamesOrInitialsThereof() {
        return (ST)this.getTyped(3, ST.class);
    }

    public ST getSuffixEgJRorIII() {
        return (ST)this.getTyped(4, ST.class);
    }

    public ST getCn5_SuffixEgJRorIII() {
        return (ST)this.getTyped(4, ST.class);
    }

    public ST getPrefixEgDR() {
        return (ST)this.getTyped(5, ST.class);
    }

    public ST getCn6_PrefixEgDR() {
        return (ST)this.getTyped(5, ST.class);
    }

    public IS getDegreeEgMD() {
        return (IS)this.getTyped(6, IS.class);
    }

    public IS getCn7_DegreeEgMD() {
        return (IS)this.getTyped(6, IS.class);
    }

    public IS getSourceTable() {
        return (IS)this.getTyped(7, IS.class);
    }

    public IS getCn8_SourceTable() {
        return (IS)this.getTyped(7, IS.class);
    }

    public HD getAssigningAuthority() {
        return (HD)this.getTyped(8, HD.class);
    }

    public HD getCn9_AssigningAuthority() {
        return (HD)this.getTyped(8, HD.class);
    }
}

