/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v23.group.OMD_O01_ORDER_DIET;
import ca.uhn.hl7v2.model.v23.group.OMD_O01_ORDER_TRAY;
import ca.uhn.hl7v2.model.v23.group.OMD_O01_PATIENT;
import ca.uhn.hl7v2.model.v23.segment.MSH;
import ca.uhn.hl7v2.model.v23.segment.NTE;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class OMD_O01
extends AbstractMessage {
    public OMD_O01() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public OMD_O01(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(NTE.class, false, true);
            this.add(OMD_O01_PATIENT.class, false, false);
            this.add(OMD_O01_ORDER_DIET.class, true, true);
            this.add(OMD_O01_ORDER_TRAY.class, false, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OMD_O01 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public NTE getNTE() {
        return (NTE)this.getTyped("NTE", NTE.class);
    }

    public NTE getNTE(int rep) {
        return (NTE)this.getTyped("NTE", rep, NTE.class);
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public OMD_O01_PATIENT getPATIENT() {
        return (OMD_O01_PATIENT)this.getTyped("PATIENT", OMD_O01_PATIENT.class);
    }

    public OMD_O01_ORDER_DIET getORDER_DIET() {
        return (OMD_O01_ORDER_DIET)this.getTyped("ORDER_DIET", OMD_O01_ORDER_DIET.class);
    }

    public OMD_O01_ORDER_DIET getORDER_DIET(int rep) {
        return (OMD_O01_ORDER_DIET)this.getTyped("ORDER_DIET", rep, OMD_O01_ORDER_DIET.class);
    }

    public int getORDER_DIETReps() {
        return this.getReps("ORDER_DIET");
    }

    public List<OMD_O01_ORDER_DIET> getORDER_DIETAll() throws HL7Exception {
        return this.getAllAsList("ORDER_DIET", OMD_O01_ORDER_DIET.class);
    }

    public void insertORDER_DIET(OMD_O01_ORDER_DIET structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER_DIET", (Structure)structure, rep);
    }

    public OMD_O01_ORDER_DIET insertORDER_DIET(int rep) throws HL7Exception {
        return (OMD_O01_ORDER_DIET)super.insertRepetition("ORDER_DIET", rep);
    }

    public OMD_O01_ORDER_DIET removeORDER_DIET(int rep) throws HL7Exception {
        return (OMD_O01_ORDER_DIET)super.removeRepetition("ORDER_DIET", rep);
    }

    public OMD_O01_ORDER_TRAY getORDER_TRAY() {
        return (OMD_O01_ORDER_TRAY)this.getTyped("ORDER_TRAY", OMD_O01_ORDER_TRAY.class);
    }

    public OMD_O01_ORDER_TRAY getORDER_TRAY(int rep) {
        return (OMD_O01_ORDER_TRAY)this.getTyped("ORDER_TRAY", rep, OMD_O01_ORDER_TRAY.class);
    }

    public int getORDER_TRAYReps() {
        return this.getReps("ORDER_TRAY");
    }

    public List<OMD_O01_ORDER_TRAY> getORDER_TRAYAll() throws HL7Exception {
        return this.getAllAsList("ORDER_TRAY", OMD_O01_ORDER_TRAY.class);
    }

    public void insertORDER_TRAY(OMD_O01_ORDER_TRAY structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER_TRAY", (Structure)structure, rep);
    }

    public OMD_O01_ORDER_TRAY insertORDER_TRAY(int rep) throws HL7Exception {
        return (OMD_O01_ORDER_TRAY)super.insertRepetition("ORDER_TRAY", rep);
    }

    public OMD_O01_ORDER_TRAY removeORDER_TRAY(int rep) throws HL7Exception {
        return (OMD_O01_ORDER_TRAY)super.removeRepetition("ORDER_TRAY", rep);
    }
}

