/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.datatype;

import ca.uhn.hl7v2.model.AbstractComposite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v23.datatype.ID;
import ca.uhn.hl7v2.model.v23.datatype.ST;

public class XPN
extends AbstractComposite {
    private Type[] data;

    public XPN(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[8];
        this.data[0] = new ST(this.getMessage());
        this.data[1] = new ST(this.getMessage());
        this.data[2] = new ST(this.getMessage());
        this.data[3] = new ST(this.getMessage());
        this.data[4] = new ST(this.getMessage());
        this.data[5] = new ST(this.getMessage());
        this.data[6] = new ID(this.getMessage(), 0);
        this.data[7] = new ID(this.getMessage(), 0);
    }

    public Type[] getComponents() {
        return this.data;
    }

    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + ((Object)((Object)this)).getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public ST getFamilyName() {
        return (ST)this.getTyped(0, ST.class);
    }

    public ST getXpn1_FamilyName() {
        return (ST)this.getTyped(0, ST.class);
    }

    public ST getGivenName() {
        return (ST)this.getTyped(1, ST.class);
    }

    public ST getXpn2_GivenName() {
        return (ST)this.getTyped(1, ST.class);
    }

    public ST getMiddleInitialOrName() {
        return (ST)this.getTyped(2, ST.class);
    }

    public ST getXpn3_MiddleInitialOrName() {
        return (ST)this.getTyped(2, ST.class);
    }

    public ST getSuffixEgJRorIII() {
        return (ST)this.getTyped(3, ST.class);
    }

    public ST getXpn4_SuffixEgJRorIII() {
        return (ST)this.getTyped(3, ST.class);
    }

    public ST getPrefixEgDR() {
        return (ST)this.getTyped(4, ST.class);
    }

    public ST getXpn5_PrefixEgDR() {
        return (ST)this.getTyped(4, ST.class);
    }

    public ST getDegreeEgMD() {
        return (ST)this.getTyped(5, ST.class);
    }

    public ST getXpn6_DegreeEgMD() {
        return (ST)this.getTyped(5, ST.class);
    }

    public ID getNameTypeCode() {
        return (ID)this.getTyped(6, ID.class);
    }

    public ID getXpn7_NameTypeCode() {
        return (ID)this.getTyped(6, ID.class);
    }

    public ID getNameRepresentationCode() {
        return (ID)this.getTyped(7, ID.class);
    }

    public ID getXpn8_NameRepresentationCode() {
        return (ID)this.getTyped(7, ID.class);
    }
}

