/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v23.group.PPR_PC1_PATIENT_VISIT;
import ca.uhn.hl7v2.model.v23.group.PPR_PC1_PROBLEM;
import ca.uhn.hl7v2.model.v23.segment.MSH;
import ca.uhn.hl7v2.model.v23.segment.PID;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class PPR_PC1
extends AbstractMessage {
    public PPR_PC1() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public PPR_PC1(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(PID.class, true, false);
            this.add(PPR_PC1_PATIENT_VISIT.class, false, false);
            this.add(PPR_PC1_PROBLEM.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PPR_PC1 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public PID getPID() {
        return (PID)this.getTyped("PID", PID.class);
    }

    public PPR_PC1_PATIENT_VISIT getPATIENT_VISIT() {
        return (PPR_PC1_PATIENT_VISIT)this.getTyped("PATIENT_VISIT", PPR_PC1_PATIENT_VISIT.class);
    }

    public PPR_PC1_PROBLEM getPROBLEM() {
        return (PPR_PC1_PROBLEM)this.getTyped("PROBLEM", PPR_PC1_PROBLEM.class);
    }

    public PPR_PC1_PROBLEM getPROBLEM(int rep) {
        return (PPR_PC1_PROBLEM)this.getTyped("PROBLEM", rep, PPR_PC1_PROBLEM.class);
    }

    public int getPROBLEMReps() {
        return this.getReps("PROBLEM");
    }

    public List<PPR_PC1_PROBLEM> getPROBLEMAll() throws HL7Exception {
        return this.getAllAsList("PROBLEM", PPR_PC1_PROBLEM.class);
    }

    public void insertPROBLEM(PPR_PC1_PROBLEM structure, int rep) throws HL7Exception {
        super.insertRepetition("PROBLEM", (Structure)structure, rep);
    }

    public PPR_PC1_PROBLEM insertPROBLEM(int rep) throws HL7Exception {
        return (PPR_PC1_PROBLEM)super.insertRepetition("PROBLEM", rep);
    }

    public PPR_PC1_PROBLEM removePROBLEM(int rep) throws HL7Exception {
        return (PPR_PC1_PROBLEM)super.removeRepetition("PROBLEM", rep);
    }
}

