/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v23.segment.MFA;
import ca.uhn.hl7v2.model.v23.segment.MFI;
import ca.uhn.hl7v2.model.v23.segment.MSA;
import ca.uhn.hl7v2.model.v23.segment.MSH;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class MFK_M05
extends AbstractMessage {
    public MFK_M05() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public MFK_M05(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(MSA.class, true, false);
            this.add(MFI.class, true, false);
            this.add(MFA.class, false, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating MFK_M05 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public MSA getMSA() {
        return (MSA)this.getTyped("MSA", MSA.class);
    }

    public MFI getMFI() {
        return (MFI)this.getTyped("MFI", MFI.class);
    }

    public MFA getMFA() {
        return (MFA)this.getTyped("MFA", MFA.class);
    }

    public MFA getMFA(int rep) {
        return (MFA)this.getTyped("MFA", rep, MFA.class);
    }

    public int getMFAReps() {
        return this.getReps("MFA");
    }

    public List<MFA> getMFAAll() throws HL7Exception {
        return this.getAllAsList("MFA", MFA.class);
    }

    public void insertMFA(MFA structure, int rep) throws HL7Exception {
        super.insertRepetition("MFA", (Structure)structure, rep);
    }

    public MFA insertMFA(int rep) throws HL7Exception {
        return (MFA)super.insertRepetition("MFA", rep);
    }

    public MFA removeMFA(int rep) throws HL7Exception {
        return (MFA)super.removeRepetition("MFA", rep);
    }
}

