/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v23.group.PPG_PCH_GOAL_OBSERVATION;
import ca.uhn.hl7v2.model.v23.group.PPG_PCH_GOAL_ROLE;
import ca.uhn.hl7v2.model.v23.group.PPG_PCH_ORDER;
import ca.uhn.hl7v2.model.v23.group.PPG_PCH_PROBLEM;
import ca.uhn.hl7v2.model.v23.segment.GOL;
import ca.uhn.hl7v2.model.v23.segment.NTE;
import ca.uhn.hl7v2.model.v23.segment.VAR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class PPG_PCH_GOAL
extends AbstractGroup {
    public PPG_PCH_GOAL(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(GOL.class, true, false, false);
            this.add(NTE.class, false, true, false);
            this.add(VAR.class, false, true, false);
            this.add(PPG_PCH_GOAL_ROLE.class, false, true, false);
            this.add(PPG_PCH_GOAL_OBSERVATION.class, false, true, false);
            this.add(PPG_PCH_PROBLEM.class, false, true, false);
            this.add(PPG_PCH_ORDER.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PPG_PCH_GOAL - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3";
    }

    public GOL getGOL() {
        GOL retVal = (GOL)this.getTyped("GOL", GOL.class);
        return retVal;
    }

    public NTE getNTE() {
        NTE retVal = (NTE)this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = (NTE)this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public VAR getVAR() {
        VAR retVal = (VAR)this.getTyped("VAR", VAR.class);
        return retVal;
    }

    public VAR getVAR(int rep) {
        VAR retVal = (VAR)this.getTyped("VAR", rep, VAR.class);
        return retVal;
    }

    public int getVARReps() {
        return this.getReps("VAR");
    }

    public List<VAR> getVARAll() throws HL7Exception {
        return this.getAllAsList("VAR", VAR.class);
    }

    public void insertVAR(VAR structure, int rep) throws HL7Exception {
        super.insertRepetition("VAR", (Structure)structure, rep);
    }

    public VAR insertVAR(int rep) throws HL7Exception {
        return (VAR)super.insertRepetition("VAR", rep);
    }

    public VAR removeVAR(int rep) throws HL7Exception {
        return (VAR)super.removeRepetition("VAR", rep);
    }

    public PPG_PCH_GOAL_ROLE getGOAL_ROLE() {
        PPG_PCH_GOAL_ROLE retVal = (PPG_PCH_GOAL_ROLE)this.getTyped("GOAL_ROLE", PPG_PCH_GOAL_ROLE.class);
        return retVal;
    }

    public PPG_PCH_GOAL_ROLE getGOAL_ROLE(int rep) {
        PPG_PCH_GOAL_ROLE retVal = (PPG_PCH_GOAL_ROLE)this.getTyped("GOAL_ROLE", rep, PPG_PCH_GOAL_ROLE.class);
        return retVal;
    }

    public int getGOAL_ROLEReps() {
        return this.getReps("GOAL_ROLE");
    }

    public List<PPG_PCH_GOAL_ROLE> getGOAL_ROLEAll() throws HL7Exception {
        return this.getAllAsList("GOAL_ROLE", PPG_PCH_GOAL_ROLE.class);
    }

    public void insertGOAL_ROLE(PPG_PCH_GOAL_ROLE structure, int rep) throws HL7Exception {
        super.insertRepetition("GOAL_ROLE", (Structure)structure, rep);
    }

    public PPG_PCH_GOAL_ROLE insertGOAL_ROLE(int rep) throws HL7Exception {
        return (PPG_PCH_GOAL_ROLE)super.insertRepetition("GOAL_ROLE", rep);
    }

    public PPG_PCH_GOAL_ROLE removeGOAL_ROLE(int rep) throws HL7Exception {
        return (PPG_PCH_GOAL_ROLE)super.removeRepetition("GOAL_ROLE", rep);
    }

    public PPG_PCH_GOAL_OBSERVATION getGOAL_OBSERVATION() {
        PPG_PCH_GOAL_OBSERVATION retVal = (PPG_PCH_GOAL_OBSERVATION)this.getTyped("GOAL_OBSERVATION", PPG_PCH_GOAL_OBSERVATION.class);
        return retVal;
    }

    public PPG_PCH_GOAL_OBSERVATION getGOAL_OBSERVATION(int rep) {
        PPG_PCH_GOAL_OBSERVATION retVal = (PPG_PCH_GOAL_OBSERVATION)this.getTyped("GOAL_OBSERVATION", rep, PPG_PCH_GOAL_OBSERVATION.class);
        return retVal;
    }

    public int getGOAL_OBSERVATIONReps() {
        return this.getReps("GOAL_OBSERVATION");
    }

    public List<PPG_PCH_GOAL_OBSERVATION> getGOAL_OBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("GOAL_OBSERVATION", PPG_PCH_GOAL_OBSERVATION.class);
    }

    public void insertGOAL_OBSERVATION(PPG_PCH_GOAL_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("GOAL_OBSERVATION", (Structure)structure, rep);
    }

    public PPG_PCH_GOAL_OBSERVATION insertGOAL_OBSERVATION(int rep) throws HL7Exception {
        return (PPG_PCH_GOAL_OBSERVATION)super.insertRepetition("GOAL_OBSERVATION", rep);
    }

    public PPG_PCH_GOAL_OBSERVATION removeGOAL_OBSERVATION(int rep) throws HL7Exception {
        return (PPG_PCH_GOAL_OBSERVATION)super.removeRepetition("GOAL_OBSERVATION", rep);
    }

    public PPG_PCH_PROBLEM getPROBLEM() {
        PPG_PCH_PROBLEM retVal = (PPG_PCH_PROBLEM)this.getTyped("PROBLEM", PPG_PCH_PROBLEM.class);
        return retVal;
    }

    public PPG_PCH_PROBLEM getPROBLEM(int rep) {
        PPG_PCH_PROBLEM retVal = (PPG_PCH_PROBLEM)this.getTyped("PROBLEM", rep, PPG_PCH_PROBLEM.class);
        return retVal;
    }

    public int getPROBLEMReps() {
        return this.getReps("PROBLEM");
    }

    public List<PPG_PCH_PROBLEM> getPROBLEMAll() throws HL7Exception {
        return this.getAllAsList("PROBLEM", PPG_PCH_PROBLEM.class);
    }

    public void insertPROBLEM(PPG_PCH_PROBLEM structure, int rep) throws HL7Exception {
        super.insertRepetition("PROBLEM", (Structure)structure, rep);
    }

    public PPG_PCH_PROBLEM insertPROBLEM(int rep) throws HL7Exception {
        return (PPG_PCH_PROBLEM)super.insertRepetition("PROBLEM", rep);
    }

    public PPG_PCH_PROBLEM removePROBLEM(int rep) throws HL7Exception {
        return (PPG_PCH_PROBLEM)super.removeRepetition("PROBLEM", rep);
    }

    public PPG_PCH_ORDER getORDER() {
        PPG_PCH_ORDER retVal = (PPG_PCH_ORDER)this.getTyped("ORDER", PPG_PCH_ORDER.class);
        return retVal;
    }

    public PPG_PCH_ORDER getORDER(int rep) {
        PPG_PCH_ORDER retVal = (PPG_PCH_ORDER)this.getTyped("ORDER", rep, PPG_PCH_ORDER.class);
        return retVal;
    }

    public int getORDERReps() {
        return this.getReps("ORDER");
    }

    public List<PPG_PCH_ORDER> getORDERAll() throws HL7Exception {
        return this.getAllAsList("ORDER", PPG_PCH_ORDER.class);
    }

    public void insertORDER(PPG_PCH_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER", (Structure)structure, rep);
    }

    public PPG_PCH_ORDER insertORDER(int rep) throws HL7Exception {
        return (PPG_PCH_ORDER)super.insertRepetition("ORDER", rep);
    }

    public PPG_PCH_ORDER removeORDER(int rep) throws HL7Exception {
        return (PPG_PCH_ORDER)super.removeRepetition("ORDER", rep);
    }
}

