/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.protocol.impl;

import ca.uhn.hl7v2.protocol.TransportException;
import ca.uhn.hl7v2.protocol.TransportLayer;

public class DualTransportConnector {
    private final TransportLayer myTransportA;
    private final TransportLayer myTransportB;
    private boolean isConnecting;

    public DualTransportConnector(TransportLayer theTransportA, TransportLayer theTransportB) {
        this.myTransportA = theTransportA;
        this.myTransportB = theTransportB;
    }

    public TransportLayer getTransportA() {
        return this.myTransportA;
    }

    public TransportLayer getTransportB() {
        return this.myTransportB;
    }

    public void connect() throws TransportException {
        this.isConnecting = true;
        ConnectThread c1 = new ConnectThread(this.myTransportA);
        ConnectThread c2 = new ConnectThread(this.myTransportB);
        c1.start();
        c2.start();
        while (!(!this.isConnecting || c1.isConnected() && c2.isConnected() || c1.getException() != null || c2.getException() != null)) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (c1.getException() != null) {
            throw c1.getException();
        }
        if (c2.getException() != null) {
            throw c2.getException();
        }
    }

    public void disconnect() throws TransportException {
        this.myTransportA.disconnect();
        this.myTransportB.disconnect();
    }

    public void cancelConnect() {
        this.isConnecting = false;
    }

    private static class ConnectThread
    extends Thread {
        private TransportLayer myTransport;
        private TransportException myException;

        public ConnectThread(TransportLayer theTransport) {
            this.myTransport = theTransport;
        }

        public boolean isConnected() {
            return this.myTransport.isConnected();
        }

        public TransportException getException() {
            return this.myException;
        }

        @Override
        public void run() {
            this.myException = null;
            try {
                this.myTransport.connect();
            }
            catch (TransportException e) {
                this.myException = e;
            }
        }
    }
}

