/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CNE;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.DTM;
import ca.uhn.hl7v2.model.v26.datatype.EI;
import ca.uhn.hl7v2.model.v26.datatype.ID;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class PTH
extends AbstractSegment {
    public PTH(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ID.class, true, 1, 2, new Object[]{this.getMessage(), new Integer(287)}, "Action Code");
            this.add(CWE.class, true, 1, 705, new Object[]{this.getMessage()}, "Pathway ID");
            this.add(EI.class, true, 1, 60, new Object[]{this.getMessage()}, "Pathway Instance ID");
            this.add(DTM.class, true, 1, 24, new Object[]{this.getMessage()}, "Pathway Established Date/Time");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage()}, "Pathway Life Cycle Status");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage()}, "Change Pathway Life Cycle Status Date/Time");
            this.add(CNE.class, false, 1, 60, new Object[]{this.getMessage()}, "Mood Code");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PTH - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public ID getActionCode() {
        ID retVal = (ID)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getPth1_ActionCode() {
        ID retVal = (ID)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getPathwayID() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getPth2_PathwayID() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public EI getPathwayInstanceID() {
        EI retVal = (EI)this.getTypedField(3, 0);
        return retVal;
    }

    public EI getPth3_PathwayInstanceID() {
        EI retVal = (EI)this.getTypedField(3, 0);
        return retVal;
    }

    public DTM getPathwayEstablishedDateTime() {
        DTM retVal = (DTM)this.getTypedField(4, 0);
        return retVal;
    }

    public DTM getPth4_PathwayEstablishedDateTime() {
        DTM retVal = (DTM)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getPathwayLifeCycleStatus() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public CWE getPth5_PathwayLifeCycleStatus() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public DTM getChangePathwayLifeCycleStatusDateTime() {
        DTM retVal = (DTM)this.getTypedField(6, 0);
        return retVal;
    }

    public DTM getPth6_ChangePathwayLifeCycleStatusDateTime() {
        DTM retVal = (DTM)this.getTypedField(6, 0);
        return retVal;
    }

    public CNE getMoodCode() {
        CNE retVal = (CNE)this.getTypedField(7, 0);
        return retVal;
    }

    public CNE getPth7_MoodCode() {
        CNE retVal = (CNE)this.getTypedField(7, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new ID(this.getMessage(), new Integer(287));
            }
            case 1: {
                return new CWE(this.getMessage());
            }
            case 2: {
                return new EI(this.getMessage());
            }
            case 3: {
                return new DTM(this.getMessage());
            }
            case 4: {
                return new CWE(this.getMessage());
            }
            case 5: {
                return new DTM(this.getMessage());
            }
            case 6: {
                return new CNE(this.getMessage());
            }
        }
        return null;
    }
}

