/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CP;
import ca.uhn.hl7v2.model.v26.datatype.EI;
import ca.uhn.hl7v2.model.v26.datatype.SI;
import ca.uhn.hl7v2.model.v26.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class PSS
extends AbstractSegment {
    public PSS(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(EI.class, true, 1, 73, new Object[]{this.getMessage()}, "Provider Product/Service Section Number");
            this.add(EI.class, false, 1, 73, new Object[]{this.getMessage()}, "Payer Product/Service Section Number");
            this.add(SI.class, true, 1, 4, new Object[]{this.getMessage()}, "Product/Service Section Sequence Number");
            this.add(CP.class, true, 1, 254, new Object[]{this.getMessage()}, "Billed Amount");
            this.add(ST.class, true, 1, 254, new Object[]{this.getMessage()}, "Section Description or Heading");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PSS - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public EI getProviderProductServiceSectionNumber() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getPss1_ProviderProductServiceSectionNumber() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getPayerProductServiceSectionNumber() {
        EI retVal = (EI)this.getTypedField(2, 0);
        return retVal;
    }

    public EI getPss2_PayerProductServiceSectionNumber() {
        EI retVal = (EI)this.getTypedField(2, 0);
        return retVal;
    }

    public SI getProductServiceSectionSequenceNumber() {
        SI retVal = (SI)this.getTypedField(3, 0);
        return retVal;
    }

    public SI getPss3_ProductServiceSectionSequenceNumber() {
        SI retVal = (SI)this.getTypedField(3, 0);
        return retVal;
    }

    public CP getBilledAmount() {
        CP retVal = (CP)this.getTypedField(4, 0);
        return retVal;
    }

    public CP getPss4_BilledAmount() {
        CP retVal = (CP)this.getTypedField(4, 0);
        return retVal;
    }

    public ST getSectionDescriptionOrHeading() {
        ST retVal = (ST)this.getTypedField(5, 0);
        return retVal;
    }

    public ST getPss5_SectionDescriptionOrHeading() {
        ST retVal = (ST)this.getTypedField(5, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new EI(this.getMessage());
            }
            case 1: {
                return new EI(this.getMessage());
            }
            case 2: {
                return new SI(this.getMessage());
            }
            case 3: {
                return new CP(this.getMessage());
            }
            case 4: {
                return new ST(this.getMessage());
            }
        }
        return null;
    }
}

