/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v26.group.SUR_P09_FACILITY;
import ca.uhn.hl7v2.model.v26.segment.MSH;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class SUR_P09
extends AbstractMessage {
    public SUR_P09() {
        this(new DefaultModelClassFactory());
    }

    public SUR_P09(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SUR_P09_FACILITY.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating SUR_P09 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.6";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SUR_P09_FACILITY getFACILITY() {
        return this.getTyped("FACILITY", SUR_P09_FACILITY.class);
    }

    public SUR_P09_FACILITY getFACILITY(int rep) {
        return this.getTyped("FACILITY", rep, SUR_P09_FACILITY.class);
    }

    public int getFACILITYReps() {
        return this.getReps("FACILITY");
    }

    public List<SUR_P09_FACILITY> getFACILITYAll() throws HL7Exception {
        return this.getAllAsList("FACILITY", SUR_P09_FACILITY.class);
    }

    public void insertFACILITY(SUR_P09_FACILITY structure, int rep) throws HL7Exception {
        super.insertRepetition("FACILITY", structure, rep);
    }

    public SUR_P09_FACILITY insertFACILITY(int rep) throws HL7Exception {
        return (SUR_P09_FACILITY)super.insertRepetition("FACILITY", rep);
    }

    public SUR_P09_FACILITY removeFACILITY(int rep) throws HL7Exception {
        return (SUR_P09_FACILITY)super.removeRepetition("FACILITY", rep);
    }
}

