/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v251.datatype.CE;
import ca.uhn.hl7v2.model.v251.datatype.EI;
import ca.uhn.hl7v2.model.v251.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class RF1
extends AbstractSegment {
    public RF1(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Referral Status");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Referral Priority");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Referral Type");
            this.add(CE.class, false, 0, 250, new Object[]{this.getMessage()}, "Referral Disposition");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Referral Category");
            this.add(EI.class, true, 1, 30, new Object[]{this.getMessage()}, "Originating Referral Identifier");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Effective Date");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Expiration Date");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Process Date");
            this.add(CE.class, false, 0, 250, new Object[]{this.getMessage()}, "Referral Reason");
            this.add(EI.class, false, 0, 30, new Object[]{this.getMessage()}, "External Referral Identifier");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RF1 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public CE getReferralStatus() {
        CE retVal = (CE)this.getTypedField(1, 0);
        return retVal;
    }

    public CE getRf11_ReferralStatus() {
        CE retVal = (CE)this.getTypedField(1, 0);
        return retVal;
    }

    public CE getReferralPriority() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getRf12_ReferralPriority() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getReferralType() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getRf13_ReferralType() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public CE[] getReferralDisposition() {
        CE[] retVal = (CE[])this.getTypedField(4, new CE[0]);
        return retVal;
    }

    public CE[] getRf14_ReferralDisposition() {
        CE[] retVal = (CE[])this.getTypedField(4, new CE[0]);
        return retVal;
    }

    public int getReferralDispositionReps() {
        return this.getReps(4);
    }

    public CE getReferralDisposition(int rep) {
        CE retVal = (CE)this.getTypedField(4, rep);
        return retVal;
    }

    public CE getRf14_ReferralDisposition(int rep) {
        CE retVal = (CE)this.getTypedField(4, rep);
        return retVal;
    }

    public int getRf14_ReferralDispositionReps() {
        return this.getReps(4);
    }

    public CE insertReferralDisposition(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(4, rep);
    }

    public CE insertRf14_ReferralDisposition(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(4, rep);
    }

    public CE removeReferralDisposition(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(4, rep);
    }

    public CE removeRf14_ReferralDisposition(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(4, rep);
    }

    public CE getReferralCategory() {
        CE retVal = (CE)this.getTypedField(5, 0);
        return retVal;
    }

    public CE getRf15_ReferralCategory() {
        CE retVal = (CE)this.getTypedField(5, 0);
        return retVal;
    }

    public EI getOriginatingReferralIdentifier() {
        EI retVal = (EI)this.getTypedField(6, 0);
        return retVal;
    }

    public EI getRf16_OriginatingReferralIdentifier() {
        EI retVal = (EI)this.getTypedField(6, 0);
        return retVal;
    }

    public TS getEffectiveDate() {
        TS retVal = (TS)this.getTypedField(7, 0);
        return retVal;
    }

    public TS getRf17_EffectiveDate() {
        TS retVal = (TS)this.getTypedField(7, 0);
        return retVal;
    }

    public TS getExpirationDate() {
        TS retVal = (TS)this.getTypedField(8, 0);
        return retVal;
    }

    public TS getRf18_ExpirationDate() {
        TS retVal = (TS)this.getTypedField(8, 0);
        return retVal;
    }

    public TS getProcessDate() {
        TS retVal = (TS)this.getTypedField(9, 0);
        return retVal;
    }

    public TS getRf19_ProcessDate() {
        TS retVal = (TS)this.getTypedField(9, 0);
        return retVal;
    }

    public CE[] getReferralReason() {
        CE[] retVal = (CE[])this.getTypedField(10, new CE[0]);
        return retVal;
    }

    public CE[] getRf110_ReferralReason() {
        CE[] retVal = (CE[])this.getTypedField(10, new CE[0]);
        return retVal;
    }

    public int getReferralReasonReps() {
        return this.getReps(10);
    }

    public CE getReferralReason(int rep) {
        CE retVal = (CE)this.getTypedField(10, rep);
        return retVal;
    }

    public CE getRf110_ReferralReason(int rep) {
        CE retVal = (CE)this.getTypedField(10, rep);
        return retVal;
    }

    public int getRf110_ReferralReasonReps() {
        return this.getReps(10);
    }

    public CE insertReferralReason(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(10, rep);
    }

    public CE insertRf110_ReferralReason(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(10, rep);
    }

    public CE removeReferralReason(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(10, rep);
    }

    public CE removeRf110_ReferralReason(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(10, rep);
    }

    public EI[] getExternalReferralIdentifier() {
        EI[] retVal = (EI[])this.getTypedField(11, new EI[0]);
        return retVal;
    }

    public EI[] getRf111_ExternalReferralIdentifier() {
        EI[] retVal = (EI[])this.getTypedField(11, new EI[0]);
        return retVal;
    }

    public int getExternalReferralIdentifierReps() {
        return this.getReps(11);
    }

    public EI getExternalReferralIdentifier(int rep) {
        EI retVal = (EI)this.getTypedField(11, rep);
        return retVal;
    }

    public EI getRf111_ExternalReferralIdentifier(int rep) {
        EI retVal = (EI)this.getTypedField(11, rep);
        return retVal;
    }

    public int getRf111_ExternalReferralIdentifierReps() {
        return this.getReps(11);
    }

    public EI insertExternalReferralIdentifier(int rep) throws HL7Exception {
        return (EI)super.insertRepetition(11, rep);
    }

    public EI insertRf111_ExternalReferralIdentifier(int rep) throws HL7Exception {
        return (EI)super.insertRepetition(11, rep);
    }

    public EI removeExternalReferralIdentifier(int rep) throws HL7Exception {
        return (EI)super.removeRepetition(11, rep);
    }

    public EI removeRf111_ExternalReferralIdentifier(int rep) throws HL7Exception {
        return (EI)super.removeRepetition(11, rep);
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CE(this.getMessage());
            }
            case 1: {
                return new CE(this.getMessage());
            }
            case 2: {
                return new CE(this.getMessage());
            }
            case 3: {
                return new CE(this.getMessage());
            }
            case 4: {
                return new CE(this.getMessage());
            }
            case 5: {
                return new EI(this.getMessage());
            }
            case 6: {
                return new TS(this.getMessage());
            }
            case 7: {
                return new TS(this.getMessage());
            }
            case 8: {
                return new TS(this.getMessage());
            }
            case 9: {
                return new CE(this.getMessage());
            }
            case 10: {
                return new EI(this.getMessage());
            }
        }
        return null;
    }
}

