/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v25.datatype.CE;
import ca.uhn.hl7v2.model.v25.datatype.ID;
import ca.uhn.hl7v2.model.v25.datatype.NM;
import ca.uhn.hl7v2.model.v25.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class QAK
extends AbstractSegment {
    public QAK(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ST.class, false, 1, 32, new Object[]{this.getMessage()}, "Query Tag");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(208)}, "Query Response Status");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Message Query Name");
            this.add(NM.class, false, 1, 10, new Object[]{this.getMessage()}, "Hit Count");
            this.add(NM.class, false, 1, 10, new Object[]{this.getMessage()}, "This payload");
            this.add(NM.class, false, 1, 10, new Object[]{this.getMessage()}, "Hits remaining");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating QAK - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public ST getQueryTag() {
        ST retVal = (ST)this.getTypedField(1, 0);
        return retVal;
    }

    public ST getQak1_QueryTag() {
        ST retVal = (ST)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getQueryResponseStatus() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getQak2_QueryResponseStatus() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getMessageQueryName() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getQak3_MessageQueryName() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public NM getHitCount() {
        NM retVal = (NM)this.getTypedField(4, 0);
        return retVal;
    }

    public NM getQak4_HitCount() {
        NM retVal = (NM)this.getTypedField(4, 0);
        return retVal;
    }

    public NM getThisPayload() {
        NM retVal = (NM)this.getTypedField(5, 0);
        return retVal;
    }

    public NM getQak5_ThisPayload() {
        NM retVal = (NM)this.getTypedField(5, 0);
        return retVal;
    }

    public NM getHitsRemaining() {
        NM retVal = (NM)this.getTypedField(6, 0);
        return retVal;
    }

    public NM getQak6_HitsRemaining() {
        NM retVal = (NM)this.getTypedField(6, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new ST(this.getMessage());
            }
            case 1: {
                return new ID(this.getMessage(), new Integer(208));
            }
            case 2: {
                return new CE(this.getMessage());
            }
            case 3: {
                return new NM(this.getMessage());
            }
            case 4: {
                return new NM(this.getMessage());
            }
            case 5: {
                return new NM(this.getMessage());
            }
        }
        return null;
    }
}

