/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v25.datatype.CE;
import ca.uhn.hl7v2.model.v25.datatype.NM;
import ca.uhn.hl7v2.model.v25.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class NDS
extends AbstractSegment {
    public NDS(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(NM.class, true, 1, 20, new Object[]{this.getMessage()}, "Notification Reference Number");
            this.add(TS.class, true, 1, 26, new Object[]{this.getMessage()}, "Notification Date/Time");
            this.add(CE.class, true, 1, 250, new Object[]{this.getMessage()}, "Notification Alert Severity");
            this.add(CE.class, true, 1, 250, new Object[]{this.getMessage()}, "Notification Code");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating NDS - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public NM getNotificationReferenceNumber() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public NM getNds1_NotificationReferenceNumber() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public TS getNotificationDateTime() {
        TS retVal = (TS)this.getTypedField(2, 0);
        return retVal;
    }

    public TS getNds2_NotificationDateTime() {
        TS retVal = (TS)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getNotificationAlertSeverity() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getNds3_NotificationAlertSeverity() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getNotificationCode() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public CE getNds4_NotificationCode() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new NM(this.getMessage());
            }
            case 1: {
                return new TS(this.getMessage());
            }
            case 2: {
                return new CE(this.getMessage());
            }
            case 3: {
                return new CE(this.getMessage());
            }
        }
        return null;
    }
}

