/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v25.group.SSR_U04_SPECIMEN_CONTAINER;
import ca.uhn.hl7v2.model.v25.segment.EQU;
import ca.uhn.hl7v2.model.v25.segment.MSH;
import ca.uhn.hl7v2.model.v25.segment.ROL;
import ca.uhn.hl7v2.model.v25.segment.SFT;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class SSR_U04
extends AbstractMessage {
    public SSR_U04() {
        this(new DefaultModelClassFactory());
    }

    public SSR_U04(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(EQU.class, true, false);
            this.add(SSR_U04_SPECIMEN_CONTAINER.class, true, true);
            this.add(ROL.class, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating SSR_U04 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.5";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public EQU getEQU() {
        return this.getTyped("EQU", EQU.class);
    }

    public SSR_U04_SPECIMEN_CONTAINER getSPECIMEN_CONTAINER() {
        return this.getTyped("SPECIMEN_CONTAINER", SSR_U04_SPECIMEN_CONTAINER.class);
    }

    public SSR_U04_SPECIMEN_CONTAINER getSPECIMEN_CONTAINER(int rep) {
        return this.getTyped("SPECIMEN_CONTAINER", rep, SSR_U04_SPECIMEN_CONTAINER.class);
    }

    public int getSPECIMEN_CONTAINERReps() {
        return this.getReps("SPECIMEN_CONTAINER");
    }

    public List<SSR_U04_SPECIMEN_CONTAINER> getSPECIMEN_CONTAINERAll() throws HL7Exception {
        return this.getAllAsList("SPECIMEN_CONTAINER", SSR_U04_SPECIMEN_CONTAINER.class);
    }

    public void insertSPECIMEN_CONTAINER(SSR_U04_SPECIMEN_CONTAINER structure, int rep) throws HL7Exception {
        super.insertRepetition("SPECIMEN_CONTAINER", structure, rep);
    }

    public SSR_U04_SPECIMEN_CONTAINER insertSPECIMEN_CONTAINER(int rep) throws HL7Exception {
        return (SSR_U04_SPECIMEN_CONTAINER)super.insertRepetition("SPECIMEN_CONTAINER", rep);
    }

    public SSR_U04_SPECIMEN_CONTAINER removeSPECIMEN_CONTAINER(int rep) throws HL7Exception {
        return (SSR_U04_SPECIMEN_CONTAINER)super.removeRepetition("SPECIMEN_CONTAINER", rep);
    }

    public ROL getROL() {
        return this.getTyped("ROL", ROL.class);
    }
}

