/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v24.segment.EQU;
import ca.uhn.hl7v2.model.v24.segment.INV;
import ca.uhn.hl7v2.model.v24.segment.MSH;
import ca.uhn.hl7v2.model.v24.segment.ROL;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class INR_U06
extends AbstractMessage {
    public INR_U06() {
        this(new DefaultModelClassFactory());
    }

    public INR_U06(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(EQU.class, true, false);
            this.add(INV.class, true, true);
            this.add(ROL.class, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating INR_U06 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.4";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public EQU getEQU() {
        return this.getTyped("EQU", EQU.class);
    }

    public INV getINV() {
        return this.getTyped("INV", INV.class);
    }

    public INV getINV(int rep) {
        return this.getTyped("INV", rep, INV.class);
    }

    public int getINVReps() {
        return this.getReps("INV");
    }

    public List<INV> getINVAll() throws HL7Exception {
        return this.getAllAsList("INV", INV.class);
    }

    public void insertINV(INV structure, int rep) throws HL7Exception {
        super.insertRepetition("INV", structure, rep);
    }

    public INV insertINV(int rep) throws HL7Exception {
        return (INV)super.insertRepetition("INV", rep);
    }

    public INV removeINV(int rep) throws HL7Exception {
        return (INV)super.removeRepetition("INV", rep);
    }

    public ROL getROL() {
        return this.getTyped("ROL", ROL.class);
    }
}

