/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v24.segment.CNS;
import ca.uhn.hl7v2.model.v24.segment.ECD;
import ca.uhn.hl7v2.model.v24.segment.EQU;
import ca.uhn.hl7v2.model.v24.segment.MSH;
import ca.uhn.hl7v2.model.v24.segment.ROL;
import ca.uhn.hl7v2.model.v24.segment.SAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class EAC_U07
extends AbstractMessage {
    public EAC_U07() {
        this(new DefaultModelClassFactory());
    }

    public EAC_U07(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(EQU.class, true, false);
            this.add(ECD.class, true, true);
            this.add(SAC.class, false, false);
            this.add(CNS.class, false, false);
            this.add(ROL.class, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating EAC_U07 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.4";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public EQU getEQU() {
        return this.getTyped("EQU", EQU.class);
    }

    public ECD getECD() {
        return this.getTyped("ECD", ECD.class);
    }

    public ECD getECD(int rep) {
        return this.getTyped("ECD", rep, ECD.class);
    }

    public int getECDReps() {
        return this.getReps("ECD");
    }

    public List<ECD> getECDAll() throws HL7Exception {
        return this.getAllAsList("ECD", ECD.class);
    }

    public void insertECD(ECD structure, int rep) throws HL7Exception {
        super.insertRepetition("ECD", structure, rep);
    }

    public ECD insertECD(int rep) throws HL7Exception {
        return (ECD)super.insertRepetition("ECD", rep);
    }

    public ECD removeECD(int rep) throws HL7Exception {
        return (ECD)super.removeRepetition("ECD", rep);
    }

    public SAC getSAC() {
        return this.getTyped("SAC", SAC.class);
    }

    public CNS getCNS() {
        return this.getTyped("CNS", CNS.class);
    }

    public ROL getROL() {
        return this.getTyped("ROL", ROL.class);
    }
}

