/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.datatype;

import ca.uhn.hl7v2.model.AbstractComposite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v24.datatype.ID;
import ca.uhn.hl7v2.model.v24.datatype.TS;

public class DLD
extends AbstractComposite {
    private Type[] data;

    public DLD(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[2];
        this.data[0] = new ID(this.getMessage(), 0);
        this.data[1] = new TS(this.getMessage());
    }

    @Override
    public Type[] getComponents() {
        return this.data;
    }

    @Override
    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + this.getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public ID getDischargeLocation() {
        return this.getTyped(0, ID.class);
    }

    public ID getDld1_DischargeLocation() {
        return this.getTyped(0, ID.class);
    }

    public TS getEffectiveDate() {
        return this.getTyped(1, TS.class);
    }

    public TS getDld2_EffectiveDate() {
        return this.getTyped(1, TS.class);
    }
}

