/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.datatype;

import ca.uhn.hl7v2.model.AbstractComposite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v24.datatype.CCP;
import ca.uhn.hl7v2.model.v24.datatype.CSU;
import ca.uhn.hl7v2.model.v24.datatype.NM;
import ca.uhn.hl7v2.model.v24.datatype.NR;
import ca.uhn.hl7v2.model.v24.datatype.WVI;
import ca.uhn.hl7v2.model.v24.datatype.WVS;

public class CD
extends AbstractComposite {
    private Type[] data;

    public CD(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[6];
        this.data[0] = new WVI(this.getMessage());
        this.data[1] = new WVS(this.getMessage());
        this.data[2] = new CSU(this.getMessage());
        this.data[3] = new CCP(this.getMessage());
        this.data[4] = new NM(this.getMessage());
        this.data[5] = new NR(this.getMessage());
    }

    @Override
    public Type[] getComponents() {
        return this.data;
    }

    @Override
    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + this.getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public WVI getChannelIdentifier() {
        return this.getTyped(0, WVI.class);
    }

    public WVI getCd1_ChannelIdentifier() {
        return this.getTyped(0, WVI.class);
    }

    public WVS getWaveformSource() {
        return this.getTyped(1, WVS.class);
    }

    public WVS getCd2_WaveformSource() {
        return this.getTyped(1, WVS.class);
    }

    public CSU getChannelSensitivityUnits() {
        return this.getTyped(2, CSU.class);
    }

    public CSU getCd3_ChannelSensitivityUnits() {
        return this.getTyped(2, CSU.class);
    }

    public CCP getChannelCalibrationParameters() {
        return this.getTyped(3, CCP.class);
    }

    public CCP getCd4_ChannelCalibrationParameters() {
        return this.getTyped(3, CCP.class);
    }

    public NM getChannelSamplingFrequency() {
        return this.getTyped(4, NM.class);
    }

    public NM getCd5_ChannelSamplingFrequency() {
        return this.getTyped(4, NM.class);
    }

    public NR getMinimumMaximumDataValues() {
        return this.getTyped(5, NR.class);
    }

    public NR getCd6_MinimumMaximumDataValues() {
        return this.getTyped(5, NR.class);
    }
}

