/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v231.datatype.CE;
import ca.uhn.hl7v2.model.v231.datatype.HD;
import ca.uhn.hl7v2.model.v231.datatype.ID;
import ca.uhn.hl7v2.model.v231.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class MFI
extends AbstractSegment {
    public MFI(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CE.class, true, 1, 60, new Object[]{this.getMessage()}, "Master File Identifier");
            this.add(HD.class, false, 1, 180, new Object[]{this.getMessage()}, "Master File Application Identifier");
            this.add(ID.class, true, 1, 3, new Object[]{this.getMessage(), new Integer(178)}, "File-Level Event Code");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Entered Date/Time");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Effective Date/Time");
            this.add(ID.class, true, 1, 2, new Object[]{this.getMessage(), new Integer(179)}, "Response Level Code");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating MFI - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public CE getMasterFileIdentifier() {
        CE retVal = (CE)this.getTypedField(1, 0);
        return retVal;
    }

    public CE getMfi1_MasterFileIdentifier() {
        CE retVal = (CE)this.getTypedField(1, 0);
        return retVal;
    }

    public HD getMasterFileApplicationIdentifier() {
        HD retVal = (HD)this.getTypedField(2, 0);
        return retVal;
    }

    public HD getMfi2_MasterFileApplicationIdentifier() {
        HD retVal = (HD)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getFileLevelEventCode() {
        ID retVal = (ID)this.getTypedField(3, 0);
        return retVal;
    }

    public ID getMfi3_FileLevelEventCode() {
        ID retVal = (ID)this.getTypedField(3, 0);
        return retVal;
    }

    public TS getEnteredDateTime() {
        TS retVal = (TS)this.getTypedField(4, 0);
        return retVal;
    }

    public TS getMfi4_EnteredDateTime() {
        TS retVal = (TS)this.getTypedField(4, 0);
        return retVal;
    }

    public TS getEffectiveDateTime() {
        TS retVal = (TS)this.getTypedField(5, 0);
        return retVal;
    }

    public TS getMfi5_EffectiveDateTime() {
        TS retVal = (TS)this.getTypedField(5, 0);
        return retVal;
    }

    public ID getResponseLevelCode() {
        ID retVal = (ID)this.getTypedField(6, 0);
        return retVal;
    }

    public ID getMfi6_ResponseLevelCode() {
        ID retVal = (ID)this.getTypedField(6, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CE(this.getMessage());
            }
            case 1: {
                return new HD(this.getMessage());
            }
            case 2: {
                return new ID(this.getMessage(), new Integer(178));
            }
            case 3: {
                return new TS(this.getMessage());
            }
            case 4: {
                return new TS(this.getMessage());
            }
            case 5: {
                return new ID(this.getMessage(), new Integer(179));
            }
        }
        return null;
    }
}

