/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v231.group.VXU_V04_IN1IN2IN3;
import ca.uhn.hl7v2.model.v231.group.VXU_V04_ORCRXARXROBXNTE;
import ca.uhn.hl7v2.model.v231.group.VXU_V04_PV1PV2;
import ca.uhn.hl7v2.model.v231.segment.MSH;
import ca.uhn.hl7v2.model.v231.segment.NK1;
import ca.uhn.hl7v2.model.v231.segment.PD1;
import ca.uhn.hl7v2.model.v231.segment.PID;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class VXU_V04
extends AbstractMessage {
    public VXU_V04() {
        this(new DefaultModelClassFactory());
    }

    public VXU_V04(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(PID.class, true, false);
            this.add(PD1.class, false, false);
            this.add(NK1.class, false, true);
            this.add(VXU_V04_PV1PV2.class, false, false);
            this.add(VXU_V04_IN1IN2IN3.class, false, true);
            this.add(VXU_V04_ORCRXARXROBXNTE.class, false, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating VXU_V04 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.3.1";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public PID getPID() {
        return this.getTyped("PID", PID.class);
    }

    public PD1 getPD1() {
        return this.getTyped("PD1", PD1.class);
    }

    public NK1 getNK1() {
        return this.getTyped("NK1", NK1.class);
    }

    public NK1 getNK1(int rep) {
        return this.getTyped("NK1", rep, NK1.class);
    }

    public int getNK1Reps() {
        return this.getReps("NK1");
    }

    public List<NK1> getNK1All() throws HL7Exception {
        return this.getAllAsList("NK1", NK1.class);
    }

    public void insertNK1(NK1 structure, int rep) throws HL7Exception {
        super.insertRepetition("NK1", structure, rep);
    }

    public NK1 insertNK1(int rep) throws HL7Exception {
        return (NK1)super.insertRepetition("NK1", rep);
    }

    public NK1 removeNK1(int rep) throws HL7Exception {
        return (NK1)super.removeRepetition("NK1", rep);
    }

    public VXU_V04_PV1PV2 getPV1PV2() {
        return this.getTyped("PV1PV2", VXU_V04_PV1PV2.class);
    }

    public VXU_V04_IN1IN2IN3 getIN1IN2IN3() {
        return this.getTyped("IN1IN2IN3", VXU_V04_IN1IN2IN3.class);
    }

    public VXU_V04_IN1IN2IN3 getIN1IN2IN3(int rep) {
        return this.getTyped("IN1IN2IN3", rep, VXU_V04_IN1IN2IN3.class);
    }

    public int getIN1IN2IN3Reps() {
        return this.getReps("IN1IN2IN3");
    }

    public List<VXU_V04_IN1IN2IN3> getIN1IN2IN3All() throws HL7Exception {
        return this.getAllAsList("IN1IN2IN3", VXU_V04_IN1IN2IN3.class);
    }

    public void insertIN1IN2IN3(VXU_V04_IN1IN2IN3 structure, int rep) throws HL7Exception {
        super.insertRepetition("IN1IN2IN3", structure, rep);
    }

    public VXU_V04_IN1IN2IN3 insertIN1IN2IN3(int rep) throws HL7Exception {
        return (VXU_V04_IN1IN2IN3)super.insertRepetition("IN1IN2IN3", rep);
    }

    public VXU_V04_IN1IN2IN3 removeIN1IN2IN3(int rep) throws HL7Exception {
        return (VXU_V04_IN1IN2IN3)super.removeRepetition("IN1IN2IN3", rep);
    }

    public VXU_V04_ORCRXARXROBXNTE getORCRXARXROBXNTE() {
        return this.getTyped("ORCRXARXROBXNTE", VXU_V04_ORCRXARXROBXNTE.class);
    }

    public VXU_V04_ORCRXARXROBXNTE getORCRXARXROBXNTE(int rep) {
        return this.getTyped("ORCRXARXROBXNTE", rep, VXU_V04_ORCRXARXROBXNTE.class);
    }

    public int getORCRXARXROBXNTEReps() {
        return this.getReps("ORCRXARXROBXNTE");
    }

    public List<VXU_V04_ORCRXARXROBXNTE> getORCRXARXROBXNTEAll() throws HL7Exception {
        return this.getAllAsList("ORCRXARXROBXNTE", VXU_V04_ORCRXARXROBXNTE.class);
    }

    public void insertORCRXARXROBXNTE(VXU_V04_ORCRXARXROBXNTE structure, int rep) throws HL7Exception {
        super.insertRepetition("ORCRXARXROBXNTE", structure, rep);
    }

    public VXU_V04_ORCRXARXROBXNTE insertORCRXARXROBXNTE(int rep) throws HL7Exception {
        return (VXU_V04_ORCRXARXROBXNTE)super.insertRepetition("ORCRXARXROBXNTE", rep);
    }

    public VXU_V04_ORCRXARXROBXNTE removeORCRXARXROBXNTE(int rep) throws HL7Exception {
        return (VXU_V04_ORCRXARXROBXNTE)super.removeRepetition("ORCRXARXROBXNTE", rep);
    }
}

