/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v231.segment.CTI;
import ca.uhn.hl7v2.model.v231.segment.NTE;
import ca.uhn.hl7v2.model.v231.segment.OBR;
import ca.uhn.hl7v2.model.v231.segment.ODS;
import ca.uhn.hl7v2.model.v231.segment.ODT;
import ca.uhn.hl7v2.model.v231.segment.ORC;
import ca.uhn.hl7v2.model.v231.segment.RQ1;
import ca.uhn.hl7v2.model.v231.segment.RQD;
import ca.uhn.hl7v2.model.v231.segment.RXO;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class ORR_O02_ORCOBRRQDRQ1RXOODSODTNTECTI
extends AbstractGroup {
    public ORR_O02_ORCOBRRQDRQ1RXOODSODTNTECTI(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false, false);
            this.add(OBR.class, true, false, true);
            this.add(RQD.class, true, false, true);
            this.add(RQ1.class, true, false, true);
            this.add(RXO.class, true, false, true);
            this.add(ODS.class, true, false, true);
            this.add(ODT.class, true, false, true);
            this.add(NTE.class, false, true, false);
            this.add(CTI.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ORR_O02_ORCOBRRQDRQ1RXOODSODTNTECTI - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3.1";
    }

    public ORC getORC() {
        ORC retVal = this.getTyped("ORC", ORC.class);
        return retVal;
    }

    public OBR getOBR() {
        OBR retVal = this.getTyped("OBR", OBR.class);
        return retVal;
    }

    public RQD getRQD() {
        RQD retVal = this.getTyped("RQD", RQD.class);
        return retVal;
    }

    public RQ1 getRQ1() {
        RQ1 retVal = this.getTyped("RQ1", RQ1.class);
        return retVal;
    }

    public RXO getRXO() {
        RXO retVal = this.getTyped("RXO", RXO.class);
        return retVal;
    }

    public ODS getODS() {
        ODS retVal = this.getTyped("ODS", ODS.class);
        return retVal;
    }

    public ODT getODT() {
        ODT retVal = this.getTyped("ODT", ODT.class);
        return retVal;
    }

    public NTE getNTE() {
        NTE retVal = this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public CTI getCTI() {
        CTI retVal = this.getTyped("CTI", CTI.class);
        return retVal;
    }

    public CTI getCTI(int rep) {
        CTI retVal = this.getTyped("CTI", rep, CTI.class);
        return retVal;
    }

    public int getCTIReps() {
        return this.getReps("CTI");
    }

    public List<CTI> getCTIAll() throws HL7Exception {
        return this.getAllAsList("CTI", CTI.class);
    }

    public void insertCTI(CTI structure, int rep) throws HL7Exception {
        super.insertRepetition("CTI", structure, rep);
    }

    public CTI insertCTI(int rep) throws HL7Exception {
        return (CTI)super.insertRepetition("CTI", rep);
    }

    public CTI removeCTI(int rep) throws HL7Exception {
        return (CTI)super.removeRepetition("CTI", rep);
    }
}

