/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v23.datatype.CE;
import ca.uhn.hl7v2.model.v23.datatype.CX;
import ca.uhn.hl7v2.model.v23.datatype.DT;
import ca.uhn.hl7v2.model.v23.datatype.ID;
import ca.uhn.hl7v2.model.v23.datatype.IS;
import ca.uhn.hl7v2.model.v23.datatype.JCC;
import ca.uhn.hl7v2.model.v23.datatype.SI;
import ca.uhn.hl7v2.model.v23.datatype.ST;
import ca.uhn.hl7v2.model.v23.datatype.TS;
import ca.uhn.hl7v2.model.v23.datatype.XAD;
import ca.uhn.hl7v2.model.v23.datatype.XON;
import ca.uhn.hl7v2.model.v23.datatype.XPN;
import ca.uhn.hl7v2.model.v23.datatype.XTN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class NK1
extends AbstractSegment {
    public NK1(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, true, 1, 4, new Object[]{this.getMessage()}, "Set ID - Next of Kin");
            this.add(XPN.class, false, 0, 48, new Object[]{this.getMessage()}, "NK Name");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Relationship");
            this.add(XAD.class, false, 0, 106, new Object[]{this.getMessage()}, "Address");
            this.add(XTN.class, false, 0, 40, new Object[]{this.getMessage()}, "Phone Number");
            this.add(XTN.class, false, 0, 40, new Object[]{this.getMessage()}, "Business Phone Number");
            this.add(CE.class, true, 1, 60, new Object[]{this.getMessage()}, "Contact Role");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Start Date");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "End Date");
            this.add(ST.class, false, 1, 60, new Object[]{this.getMessage()}, "Next of Kin/Associated Parties Job Title");
            this.add(JCC.class, false, 1, 20, new Object[]{this.getMessage()}, "Next of Kin Job/Associated Parties Code/Class");
            this.add(CX.class, false, 1, 20, new Object[]{this.getMessage()}, "Next of Kin/Associated Parties Employee Number");
            this.add(XON.class, false, 0, 60, new Object[]{this.getMessage()}, "Organization Name");
            this.add(IS.class, false, 0, 1, new Object[]{this.getMessage(), new Integer(2)}, "Marital Status");
            this.add(IS.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(1)}, "Sex");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Date of Birth");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(223)}, "Living Dependency");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(9)}, "Ambulatory Status");
            this.add(IS.class, false, 1, 4, new Object[]{this.getMessage(), new Integer(171)}, "Citizenship");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Primary Language");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(220)}, "Living Arrangement");
            this.add(CE.class, false, 1, 1, new Object[]{this.getMessage()}, "Publicity Indicator");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Protection Indicator");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(231)}, "Student Indicator");
            this.add(IS.class, false, 1, 3, new Object[]{this.getMessage(), new Integer(6)}, "Religion");
            this.add(XPN.class, false, 1, 48, new Object[]{this.getMessage()}, "Mother\u2019s Maiden Name");
            this.add(CE.class, false, 1, 80, new Object[]{this.getMessage()}, "Nationality Code");
            this.add(IS.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(189)}, "Ethnic Group");
            this.add(CE.class, false, 1, 2, new Object[]{this.getMessage()}, "Contact Reason");
            this.add(XPN.class, false, 0, 48, new Object[]{this.getMessage()}, "Contact Person's Name");
            this.add(XTN.class, false, 0, 40, new Object[]{this.getMessage()}, "Contact Person\u2019s Telephone Number");
            this.add(XAD.class, false, 0, 106, new Object[]{this.getMessage()}, "Contact Person\u2019s Address");
            this.add(CX.class, false, 0, 32, new Object[]{this.getMessage()}, "Associated Party\u2019s Identifiers");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(311)}, "Job Status");
            this.add(IS.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(5)}, "Race");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(310)}, "Handicap");
            this.add(ST.class, false, 1, 16, new Object[]{this.getMessage()}, "Contact Person Social Security Number");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating NK1 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDNextOfKin() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getNk11_SetIDNextOfKin() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public XPN[] getNKName() {
        XPN[] retVal = (XPN[])this.getTypedField(2, new XPN[0]);
        return retVal;
    }

    public XPN[] getNk12_NKName() {
        XPN[] retVal = (XPN[])this.getTypedField(2, new XPN[0]);
        return retVal;
    }

    public int getNKNameReps() {
        return this.getReps(2);
    }

    public XPN getNKName(int rep) {
        XPN retVal = (XPN)this.getTypedField(2, rep);
        return retVal;
    }

    public XPN getNk12_NKName(int rep) {
        XPN retVal = (XPN)this.getTypedField(2, rep);
        return retVal;
    }

    public int getNk12_NKNameReps() {
        return this.getReps(2);
    }

    public XPN insertNKName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(2, rep);
    }

    public XPN insertNk12_NKName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(2, rep);
    }

    public XPN removeNKName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(2, rep);
    }

    public XPN removeNk12_NKName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(2, rep);
    }

    public CE getRelationship() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getNk13_Relationship() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public XAD[] getAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(4, new XAD[0]);
        return retVal;
    }

    public XAD[] getNk14_Address() {
        XAD[] retVal = (XAD[])this.getTypedField(4, new XAD[0]);
        return retVal;
    }

    public int getAddressReps() {
        return this.getReps(4);
    }

    public XAD getAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(4, rep);
        return retVal;
    }

    public XAD getNk14_Address(int rep) {
        XAD retVal = (XAD)this.getTypedField(4, rep);
        return retVal;
    }

    public int getNk14_AddressReps() {
        return this.getReps(4);
    }

    public XAD insertAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(4, rep);
    }

    public XAD insertNk14_Address(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(4, rep);
    }

    public XAD removeAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(4, rep);
    }

    public XAD removeNk14_Address(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(4, rep);
    }

    public XTN[] getPhoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(5, new XTN[0]);
        return retVal;
    }

    public XTN[] getNk15_PhoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(5, new XTN[0]);
        return retVal;
    }

    public int getPhoneNumberReps() {
        return this.getReps(5);
    }

    public XTN getPhoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(5, rep);
        return retVal;
    }

    public XTN getNk15_PhoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(5, rep);
        return retVal;
    }

    public int getNk15_PhoneNumberReps() {
        return this.getReps(5);
    }

    public XTN insertPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(5, rep);
    }

    public XTN insertNk15_PhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(5, rep);
    }

    public XTN removePhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(5, rep);
    }

    public XTN removeNk15_PhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(5, rep);
    }

    public XTN[] getBusinessPhoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(6, new XTN[0]);
        return retVal;
    }

    public XTN[] getNk16_BusinessPhoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(6, new XTN[0]);
        return retVal;
    }

    public int getBusinessPhoneNumberReps() {
        return this.getReps(6);
    }

    public XTN getBusinessPhoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(6, rep);
        return retVal;
    }

    public XTN getNk16_BusinessPhoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(6, rep);
        return retVal;
    }

    public int getNk16_BusinessPhoneNumberReps() {
        return this.getReps(6);
    }

    public XTN insertBusinessPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(6, rep);
    }

    public XTN insertNk16_BusinessPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(6, rep);
    }

    public XTN removeBusinessPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(6, rep);
    }

    public XTN removeNk16_BusinessPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(6, rep);
    }

    public CE getContactRole() {
        CE retVal = (CE)this.getTypedField(7, 0);
        return retVal;
    }

    public CE getNk17_ContactRole() {
        CE retVal = (CE)this.getTypedField(7, 0);
        return retVal;
    }

    public DT getStartDate() {
        DT retVal = (DT)this.getTypedField(8, 0);
        return retVal;
    }

    public DT getNk18_StartDate() {
        DT retVal = (DT)this.getTypedField(8, 0);
        return retVal;
    }

    public DT getEndDate() {
        DT retVal = (DT)this.getTypedField(9, 0);
        return retVal;
    }

    public DT getNk19_EndDate() {
        DT retVal = (DT)this.getTypedField(9, 0);
        return retVal;
    }

    public ST getNextOfKinAssociatedPartiesJobTitle() {
        ST retVal = (ST)this.getTypedField(10, 0);
        return retVal;
    }

    public ST getNk110_NextOfKinAssociatedPartiesJobTitle() {
        ST retVal = (ST)this.getTypedField(10, 0);
        return retVal;
    }

    public JCC getNextOfKinJobAssociatedPartiesCodeClass() {
        JCC retVal = (JCC)this.getTypedField(11, 0);
        return retVal;
    }

    public JCC getNk111_NextOfKinJobAssociatedPartiesCodeClass() {
        JCC retVal = (JCC)this.getTypedField(11, 0);
        return retVal;
    }

    public CX getNextOfKinAssociatedPartiesEmployeeNumber() {
        CX retVal = (CX)this.getTypedField(12, 0);
        return retVal;
    }

    public CX getNk112_NextOfKinAssociatedPartiesEmployeeNumber() {
        CX retVal = (CX)this.getTypedField(12, 0);
        return retVal;
    }

    public XON[] getOrganizationName() {
        XON[] retVal = (XON[])this.getTypedField(13, new XON[0]);
        return retVal;
    }

    public XON[] getNk113_OrganizationName() {
        XON[] retVal = (XON[])this.getTypedField(13, new XON[0]);
        return retVal;
    }

    public int getOrganizationNameReps() {
        return this.getReps(13);
    }

    public XON getOrganizationName(int rep) {
        XON retVal = (XON)this.getTypedField(13, rep);
        return retVal;
    }

    public XON getNk113_OrganizationName(int rep) {
        XON retVal = (XON)this.getTypedField(13, rep);
        return retVal;
    }

    public int getNk113_OrganizationNameReps() {
        return this.getReps(13);
    }

    public XON insertOrganizationName(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(13, rep);
    }

    public XON insertNk113_OrganizationName(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(13, rep);
    }

    public XON removeOrganizationName(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(13, rep);
    }

    public XON removeNk113_OrganizationName(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(13, rep);
    }

    public IS[] getMaritalStatus() {
        IS[] retVal = (IS[])this.getTypedField(14, new IS[0]);
        return retVal;
    }

    public IS[] getNk114_MaritalStatus() {
        IS[] retVal = (IS[])this.getTypedField(14, new IS[0]);
        return retVal;
    }

    public int getMaritalStatusReps() {
        return this.getReps(14);
    }

    public IS getMaritalStatus(int rep) {
        IS retVal = (IS)this.getTypedField(14, rep);
        return retVal;
    }

    public IS getNk114_MaritalStatus(int rep) {
        IS retVal = (IS)this.getTypedField(14, rep);
        return retVal;
    }

    public int getNk114_MaritalStatusReps() {
        return this.getReps(14);
    }

    public IS insertMaritalStatus(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(14, rep);
    }

    public IS insertNk114_MaritalStatus(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(14, rep);
    }

    public IS removeMaritalStatus(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(14, rep);
    }

    public IS removeNk114_MaritalStatus(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(14, rep);
    }

    public IS getSex() {
        IS retVal = (IS)this.getTypedField(15, 0);
        return retVal;
    }

    public IS getNk115_Sex() {
        IS retVal = (IS)this.getTypedField(15, 0);
        return retVal;
    }

    public TS getDateOfBirth() {
        TS retVal = (TS)this.getTypedField(16, 0);
        return retVal;
    }

    public TS getNk116_DateOfBirth() {
        TS retVal = (TS)this.getTypedField(16, 0);
        return retVal;
    }

    public IS getLivingDependency() {
        IS retVal = (IS)this.getTypedField(17, 0);
        return retVal;
    }

    public IS getNk117_LivingDependency() {
        IS retVal = (IS)this.getTypedField(17, 0);
        return retVal;
    }

    public IS getAmbulatoryStatus() {
        IS retVal = (IS)this.getTypedField(18, 0);
        return retVal;
    }

    public IS getNk118_AmbulatoryStatus() {
        IS retVal = (IS)this.getTypedField(18, 0);
        return retVal;
    }

    public IS getCitizenship() {
        IS retVal = (IS)this.getTypedField(19, 0);
        return retVal;
    }

    public IS getNk119_Citizenship() {
        IS retVal = (IS)this.getTypedField(19, 0);
        return retVal;
    }

    public CE getPrimaryLanguage() {
        CE retVal = (CE)this.getTypedField(20, 0);
        return retVal;
    }

    public CE getNk120_PrimaryLanguage() {
        CE retVal = (CE)this.getTypedField(20, 0);
        return retVal;
    }

    public IS getLivingArrangement() {
        IS retVal = (IS)this.getTypedField(21, 0);
        return retVal;
    }

    public IS getNk121_LivingArrangement() {
        IS retVal = (IS)this.getTypedField(21, 0);
        return retVal;
    }

    public CE getPublicityIndicator() {
        CE retVal = (CE)this.getTypedField(22, 0);
        return retVal;
    }

    public CE getNk122_PublicityIndicator() {
        CE retVal = (CE)this.getTypedField(22, 0);
        return retVal;
    }

    public ID getProtectionIndicator() {
        ID retVal = (ID)this.getTypedField(23, 0);
        return retVal;
    }

    public ID getNk123_ProtectionIndicator() {
        ID retVal = (ID)this.getTypedField(23, 0);
        return retVal;
    }

    public IS getStudentIndicator() {
        IS retVal = (IS)this.getTypedField(24, 0);
        return retVal;
    }

    public IS getNk124_StudentIndicator() {
        IS retVal = (IS)this.getTypedField(24, 0);
        return retVal;
    }

    public IS getReligion() {
        IS retVal = (IS)this.getTypedField(25, 0);
        return retVal;
    }

    public IS getNk125_Religion() {
        IS retVal = (IS)this.getTypedField(25, 0);
        return retVal;
    }

    public XPN getMotherSMaidenName() {
        XPN retVal = (XPN)this.getTypedField(26, 0);
        return retVal;
    }

    public XPN getNk126_MotherSMaidenName() {
        XPN retVal = (XPN)this.getTypedField(26, 0);
        return retVal;
    }

    public CE getNationalityCode() {
        CE retVal = (CE)this.getTypedField(27, 0);
        return retVal;
    }

    public CE getNk127_NationalityCode() {
        CE retVal = (CE)this.getTypedField(27, 0);
        return retVal;
    }

    public IS getEthnicGroup() {
        IS retVal = (IS)this.getTypedField(28, 0);
        return retVal;
    }

    public IS getNk128_EthnicGroup() {
        IS retVal = (IS)this.getTypedField(28, 0);
        return retVal;
    }

    public CE getContactReason() {
        CE retVal = (CE)this.getTypedField(29, 0);
        return retVal;
    }

    public CE getNk129_ContactReason() {
        CE retVal = (CE)this.getTypedField(29, 0);
        return retVal;
    }

    public XPN[] getContactPersonSName() {
        XPN[] retVal = (XPN[])this.getTypedField(30, new XPN[0]);
        return retVal;
    }

    public XPN[] getNk130_ContactPersonSName() {
        XPN[] retVal = (XPN[])this.getTypedField(30, new XPN[0]);
        return retVal;
    }

    public int getContactPersonSNameReps() {
        return this.getReps(30);
    }

    public XPN getContactPersonSName(int rep) {
        XPN retVal = (XPN)this.getTypedField(30, rep);
        return retVal;
    }

    public XPN getNk130_ContactPersonSName(int rep) {
        XPN retVal = (XPN)this.getTypedField(30, rep);
        return retVal;
    }

    public int getNk130_ContactPersonSNameReps() {
        return this.getReps(30);
    }

    public XPN insertContactPersonSName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(30, rep);
    }

    public XPN insertNk130_ContactPersonSName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(30, rep);
    }

    public XPN removeContactPersonSName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(30, rep);
    }

    public XPN removeNk130_ContactPersonSName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(30, rep);
    }

    public XTN[] getContactPersonSTelephoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(31, new XTN[0]);
        return retVal;
    }

    public XTN[] getNk131_ContactPersonSTelephoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(31, new XTN[0]);
        return retVal;
    }

    public int getContactPersonSTelephoneNumberReps() {
        return this.getReps(31);
    }

    public XTN getContactPersonSTelephoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(31, rep);
        return retVal;
    }

    public XTN getNk131_ContactPersonSTelephoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(31, rep);
        return retVal;
    }

    public int getNk131_ContactPersonSTelephoneNumberReps() {
        return this.getReps(31);
    }

    public XTN insertContactPersonSTelephoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(31, rep);
    }

    public XTN insertNk131_ContactPersonSTelephoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(31, rep);
    }

    public XTN removeContactPersonSTelephoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(31, rep);
    }

    public XTN removeNk131_ContactPersonSTelephoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(31, rep);
    }

    public XAD[] getContactPersonSAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(32, new XAD[0]);
        return retVal;
    }

    public XAD[] getNk132_ContactPersonSAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(32, new XAD[0]);
        return retVal;
    }

    public int getContactPersonSAddressReps() {
        return this.getReps(32);
    }

    public XAD getContactPersonSAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(32, rep);
        return retVal;
    }

    public XAD getNk132_ContactPersonSAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(32, rep);
        return retVal;
    }

    public int getNk132_ContactPersonSAddressReps() {
        return this.getReps(32);
    }

    public XAD insertContactPersonSAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(32, rep);
    }

    public XAD insertNk132_ContactPersonSAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(32, rep);
    }

    public XAD removeContactPersonSAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(32, rep);
    }

    public XAD removeNk132_ContactPersonSAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(32, rep);
    }

    public CX[] getAssociatedPartySIdentifiers() {
        CX[] retVal = (CX[])this.getTypedField(33, new CX[0]);
        return retVal;
    }

    public CX[] getNk133_AssociatedPartySIdentifiers() {
        CX[] retVal = (CX[])this.getTypedField(33, new CX[0]);
        return retVal;
    }

    public int getAssociatedPartySIdentifiersReps() {
        return this.getReps(33);
    }

    public CX getAssociatedPartySIdentifiers(int rep) {
        CX retVal = (CX)this.getTypedField(33, rep);
        return retVal;
    }

    public CX getNk133_AssociatedPartySIdentifiers(int rep) {
        CX retVal = (CX)this.getTypedField(33, rep);
        return retVal;
    }

    public int getNk133_AssociatedPartySIdentifiersReps() {
        return this.getReps(33);
    }

    public CX insertAssociatedPartySIdentifiers(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(33, rep);
    }

    public CX insertNk133_AssociatedPartySIdentifiers(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(33, rep);
    }

    public CX removeAssociatedPartySIdentifiers(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(33, rep);
    }

    public CX removeNk133_AssociatedPartySIdentifiers(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(33, rep);
    }

    public IS getJobStatus() {
        IS retVal = (IS)this.getTypedField(34, 0);
        return retVal;
    }

    public IS getNk134_JobStatus() {
        IS retVal = (IS)this.getTypedField(34, 0);
        return retVal;
    }

    public IS getRace() {
        IS retVal = (IS)this.getTypedField(35, 0);
        return retVal;
    }

    public IS getNk135_Race() {
        IS retVal = (IS)this.getTypedField(35, 0);
        return retVal;
    }

    public IS getHandicap() {
        IS retVal = (IS)this.getTypedField(36, 0);
        return retVal;
    }

    public IS getNk136_Handicap() {
        IS retVal = (IS)this.getTypedField(36, 0);
        return retVal;
    }

    public ST getContactPersonSocialSecurityNumber() {
        ST retVal = (ST)this.getTypedField(37, 0);
        return retVal;
    }

    public ST getNk137_ContactPersonSocialSecurityNumber() {
        ST retVal = (ST)this.getTypedField(37, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new XPN(this.getMessage());
            }
            case 2: {
                return new CE(this.getMessage());
            }
            case 3: {
                return new XAD(this.getMessage());
            }
            case 4: {
                return new XTN(this.getMessage());
            }
            case 5: {
                return new XTN(this.getMessage());
            }
            case 6: {
                return new CE(this.getMessage());
            }
            case 7: {
                return new DT(this.getMessage());
            }
            case 8: {
                return new DT(this.getMessage());
            }
            case 9: {
                return new ST(this.getMessage());
            }
            case 10: {
                return new JCC(this.getMessage());
            }
            case 11: {
                return new CX(this.getMessage());
            }
            case 12: {
                return new XON(this.getMessage());
            }
            case 13: {
                return new IS(this.getMessage(), new Integer(2));
            }
            case 14: {
                return new IS(this.getMessage(), new Integer(1));
            }
            case 15: {
                return new TS(this.getMessage());
            }
            case 16: {
                return new IS(this.getMessage(), new Integer(223));
            }
            case 17: {
                return new IS(this.getMessage(), new Integer(9));
            }
            case 18: {
                return new IS(this.getMessage(), new Integer(171));
            }
            case 19: {
                return new CE(this.getMessage());
            }
            case 20: {
                return new IS(this.getMessage(), new Integer(220));
            }
            case 21: {
                return new CE(this.getMessage());
            }
            case 22: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 23: {
                return new IS(this.getMessage(), new Integer(231));
            }
            case 24: {
                return new IS(this.getMessage(), new Integer(6));
            }
            case 25: {
                return new XPN(this.getMessage());
            }
            case 26: {
                return new CE(this.getMessage());
            }
            case 27: {
                return new IS(this.getMessage(), new Integer(189));
            }
            case 28: {
                return new CE(this.getMessage());
            }
            case 29: {
                return new XPN(this.getMessage());
            }
            case 30: {
                return new XTN(this.getMessage());
            }
            case 31: {
                return new XAD(this.getMessage());
            }
            case 32: {
                return new CX(this.getMessage());
            }
            case 33: {
                return new IS(this.getMessage(), new Integer(311));
            }
            case 34: {
                return new IS(this.getMessage(), new Integer(5));
            }
            case 35: {
                return new IS(this.getMessage(), new Integer(310));
            }
            case 36: {
                return new ST(this.getMessage());
            }
        }
        return null;
    }
}

