/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v23.datatype.CE;
import ca.uhn.hl7v2.model.v23.datatype.EI;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class CTI
extends AbstractSegment {
    public CTI(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(EI.class, true, 1, 60, new Object[]{this.getMessage()}, "Sponsor Study ID");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Study Phase Identifier");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Study Scheduled Time Point");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating CTI - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public EI getSponsorStudyID() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getCti1_SponsorStudyID() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public CE getStudyPhaseIdentifier() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getCti2_StudyPhaseIdentifier() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getStudyScheduledTimePoint() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getCti3_StudyScheduledTimePoint() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new EI(this.getMessage());
            }
            case 1: {
                return new CE(this.getMessage());
            }
            case 2: {
                return new CE(this.getMessage());
            }
        }
        return null;
    }
}

