/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.datatype;

import ca.uhn.hl7v2.model.AbstractComposite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v23.datatype.CN;
import ca.uhn.hl7v2.model.v23.datatype.HD;
import ca.uhn.hl7v2.model.v23.datatype.IS;
import ca.uhn.hl7v2.model.v23.datatype.ST;
import ca.uhn.hl7v2.model.v23.datatype.TS;

public class CM_NDL
extends AbstractComposite {
    private Type[] data;

    public CM_NDL(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[11];
        this.data[0] = new CN(this.getMessage());
        this.data[1] = new TS(this.getMessage());
        this.data[2] = new TS(this.getMessage());
        this.data[3] = new IS(this.getMessage(), 0);
        this.data[4] = new IS(this.getMessage(), 0);
        this.data[5] = new IS(this.getMessage(), 0);
        this.data[6] = new HD(this.getMessage());
        this.data[7] = new IS(this.getMessage(), 0);
        this.data[8] = new IS(this.getMessage(), 0);
        this.data[9] = new IS(this.getMessage(), 0);
        this.data[10] = new ST(this.getMessage());
    }

    @Override
    public Type[] getComponents() {
        return this.data;
    }

    @Override
    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + this.getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public CN getOPName() {
        return this.getTyped(0, CN.class);
    }

    public CN getCm_ndl1_OPName() {
        return this.getTyped(0, CN.class);
    }

    public TS getStartDateTime() {
        return this.getTyped(1, TS.class);
    }

    public TS getCm_ndl2_StartDateTime() {
        return this.getTyped(1, TS.class);
    }

    public TS getEndDateTime() {
        return this.getTyped(2, TS.class);
    }

    public TS getCm_ndl3_EndDateTime() {
        return this.getTyped(2, TS.class);
    }

    public IS getPointOfCare() {
        return this.getTyped(3, IS.class);
    }

    public IS getCm_ndl4_PointOfCare() {
        return this.getTyped(3, IS.class);
    }

    public IS getRoom() {
        return this.getTyped(4, IS.class);
    }

    public IS getCm_ndl5_Room() {
        return this.getTyped(4, IS.class);
    }

    public IS getBed() {
        return this.getTyped(5, IS.class);
    }

    public IS getCm_ndl6_Bed() {
        return this.getTyped(5, IS.class);
    }

    public HD getFacility() {
        return this.getTyped(6, HD.class);
    }

    public HD getCm_ndl7_Facility() {
        return this.getTyped(6, HD.class);
    }

    public IS getLocationStatus() {
        return this.getTyped(7, IS.class);
    }

    public IS getCm_ndl8_LocationStatus() {
        return this.getTyped(7, IS.class);
    }

    public IS getPersonLocationType() {
        return this.getTyped(8, IS.class);
    }

    public IS getCm_ndl9_PersonLocationType() {
        return this.getTyped(8, IS.class);
    }

    public IS getBuilding() {
        return this.getTyped(9, IS.class);
    }

    public IS getCm_ndl10_Building() {
        return this.getTyped(9, IS.class);
    }

    public ST getFloor() {
        return this.getTyped(10, ST.class);
    }

    public ST getCm_ndl11_Floor() {
        return this.getTyped(10, ST.class);
    }
}

