/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation.builder.support;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.MessageVisitorFactory;
import ca.uhn.hl7v2.model.MessageVisitors;
import ca.uhn.hl7v2.validation.ValidationException;
import ca.uhn.hl7v2.validation.builder.support.ValidatingMessageVisitor;
import ca.uhn.hl7v2.validation.impl.AbstractMessageRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisitorMessageRule
extends AbstractMessageRule {
    private final MessageVisitorFactory<? extends ValidatingMessageVisitor> visitorFactory;

    public VisitorMessageRule(MessageVisitorFactory<? extends ValidatingMessageVisitor> visitorFactory) {
        if (visitorFactory == null) {
            throw new IllegalArgumentException("Visitor factory must not be null");
        }
        this.visitorFactory = visitorFactory;
    }

    @Override
    public ValidationException[] apply(Message message) {
        try {
            ValidatingMessageVisitor visitor = this.visitorFactory.create();
            MessageVisitors.visit(message, visitor);
            return visitor.getValidationExceptions();
        }
        catch (HL7Exception e) {
            return new ValidationException[]{new ValidationException(e)};
        }
    }
}

