/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.Varies;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.DTM;
import ca.uhn.hl7v2.model.v26.datatype.ID;
import ca.uhn.hl7v2.model.v26.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class MFA
extends AbstractSegment {
    public MFA(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ID.class, true, 1, 3, new Object[]{this.getMessage(), new Integer(180)}, "Record-Level Event Code");
            this.add(ST.class, false, 1, 20, new Object[]{this.getMessage()}, "MFN Control ID");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage()}, "Event Completion Date/Time");
            this.add(CWE.class, true, 1, 250, new Object[]{this.getMessage()}, "MFN Record Level Error Return");
            this.add(Varies.class, true, 0, 250, new Object[]{this.getMessage()}, "Primary Key Value - MFA");
            this.add(ID.class, true, 0, 3, new Object[]{this.getMessage(), new Integer(355)}, "Primary Key Value Type - MFA");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating MFA - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public ID getRecordLevelEventCode() {
        ID retVal = (ID)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getMfa1_RecordLevelEventCode() {
        ID retVal = (ID)this.getTypedField(1, 0);
        return retVal;
    }

    public ST getMFNControlID() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getMfa2_MFNControlID() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public DTM getEventCompletionDateTime() {
        DTM retVal = (DTM)this.getTypedField(3, 0);
        return retVal;
    }

    public DTM getMfa3_EventCompletionDateTime() {
        DTM retVal = (DTM)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getMFNRecordLevelErrorReturn() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getMfa4_MFNRecordLevelErrorReturn() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public Varies[] getPrimaryKeyValueMFA() {
        Varies[] retVal = (Varies[])this.getTypedField(5, new Varies[0]);
        return retVal;
    }

    public Varies[] getMfa5_PrimaryKeyValueMFA() {
        Varies[] retVal = (Varies[])this.getTypedField(5, new Varies[0]);
        return retVal;
    }

    public int getPrimaryKeyValueMFAReps() {
        return this.getReps(5);
    }

    public Varies getPrimaryKeyValueMFA(int rep) {
        Varies retVal = (Varies)this.getTypedField(5, rep);
        return retVal;
    }

    public Varies getMfa5_PrimaryKeyValueMFA(int rep) {
        Varies retVal = (Varies)this.getTypedField(5, rep);
        return retVal;
    }

    public int getMfa5_PrimaryKeyValueMFAReps() {
        return this.getReps(5);
    }

    public Varies insertPrimaryKeyValueMFA(int rep) throws HL7Exception {
        return (Varies)super.insertRepetition(5, rep);
    }

    public Varies insertMfa5_PrimaryKeyValueMFA(int rep) throws HL7Exception {
        return (Varies)super.insertRepetition(5, rep);
    }

    public Varies removePrimaryKeyValueMFA(int rep) throws HL7Exception {
        return (Varies)super.removeRepetition(5, rep);
    }

    public Varies removeMfa5_PrimaryKeyValueMFA(int rep) throws HL7Exception {
        return (Varies)super.removeRepetition(5, rep);
    }

    public ID[] getPrimaryKeyValueTypeMFA() {
        ID[] retVal = (ID[])this.getTypedField(6, new ID[0]);
        return retVal;
    }

    public ID[] getMfa6_PrimaryKeyValueTypeMFA() {
        ID[] retVal = (ID[])this.getTypedField(6, new ID[0]);
        return retVal;
    }

    public int getPrimaryKeyValueTypeMFAReps() {
        return this.getReps(6);
    }

    public ID getPrimaryKeyValueTypeMFA(int rep) {
        ID retVal = (ID)this.getTypedField(6, rep);
        return retVal;
    }

    public ID getMfa6_PrimaryKeyValueTypeMFA(int rep) {
        ID retVal = (ID)this.getTypedField(6, rep);
        return retVal;
    }

    public int getMfa6_PrimaryKeyValueTypeMFAReps() {
        return this.getReps(6);
    }

    public ID insertPrimaryKeyValueTypeMFA(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(6, rep);
    }

    public ID insertMfa6_PrimaryKeyValueTypeMFA(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(6, rep);
    }

    public ID removePrimaryKeyValueTypeMFA(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(6, rep);
    }

    public ID removeMfa6_PrimaryKeyValueTypeMFA(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(6, rep);
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new ID(this.getMessage(), new Integer(180));
            }
            case 1: {
                return new ST(this.getMessage());
            }
            case 2: {
                return new DTM(this.getMessage());
            }
            case 3: {
                return new CWE(this.getMessage());
            }
            case 4: {
                return new Varies(this.getMessage());
            }
            case 5: {
                return new ID(this.getMessage(), new Integer(355));
            }
        }
        return null;
    }
}

