/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.DTM;
import ca.uhn.hl7v2.model.v26.datatype.TX;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class ECR
extends AbstractSegment {
    public ECR(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CWE.class, true, 1, 705, new Object[]{this.getMessage()}, "Command Response");
            this.add(DTM.class, true, 1, 24, new Object[]{this.getMessage()}, "Date/Time Completed");
            this.add(TX.class, false, 0, 65536, new Object[]{this.getMessage()}, "Command Response Parameters");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ECR - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public CWE getCommandResponse() {
        CWE retVal = (CWE)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getEcr1_CommandResponse() {
        CWE retVal = (CWE)this.getTypedField(1, 0);
        return retVal;
    }

    public DTM getDateTimeCompleted() {
        DTM retVal = (DTM)this.getTypedField(2, 0);
        return retVal;
    }

    public DTM getEcr2_DateTimeCompleted() {
        DTM retVal = (DTM)this.getTypedField(2, 0);
        return retVal;
    }

    public TX[] getCommandResponseParameters() {
        TX[] retVal = (TX[])this.getTypedField(3, new TX[0]);
        return retVal;
    }

    public TX[] getEcr3_CommandResponseParameters() {
        TX[] retVal = (TX[])this.getTypedField(3, new TX[0]);
        return retVal;
    }

    public int getCommandResponseParametersReps() {
        return this.getReps(3);
    }

    public TX getCommandResponseParameters(int rep) {
        TX retVal = (TX)this.getTypedField(3, rep);
        return retVal;
    }

    public TX getEcr3_CommandResponseParameters(int rep) {
        TX retVal = (TX)this.getTypedField(3, rep);
        return retVal;
    }

    public int getEcr3_CommandResponseParametersReps() {
        return this.getReps(3);
    }

    public TX insertCommandResponseParameters(int rep) throws HL7Exception {
        return (TX)super.insertRepetition(3, rep);
    }

    public TX insertEcr3_CommandResponseParameters(int rep) throws HL7Exception {
        return (TX)super.insertRepetition(3, rep);
    }

    public TX removeCommandResponseParameters(int rep) throws HL7Exception {
        return (TX)super.removeRepetition(3, rep);
    }

    public TX removeEcr3_CommandResponseParameters(int rep) throws HL7Exception {
        return (TX)super.removeRepetition(3, rep);
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CWE(this.getMessage());
            }
            case 1: {
                return new DTM(this.getMessage());
            }
            case 2: {
                return new TX(this.getMessage());
            }
        }
        return null;
    }
}

