/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v26.group.ORF_R04_QUERY_RESPONSE;
import ca.uhn.hl7v2.model.v26.segment.DSC;
import ca.uhn.hl7v2.model.v26.segment.ERR;
import ca.uhn.hl7v2.model.v26.segment.MSA;
import ca.uhn.hl7v2.model.v26.segment.MSH;
import ca.uhn.hl7v2.model.v26.segment.QAK;
import ca.uhn.hl7v2.model.v26.segment.QRD;
import ca.uhn.hl7v2.model.v26.segment.QRF;
import ca.uhn.hl7v2.model.v26.segment.SFT;
import ca.uhn.hl7v2.model.v26.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ORF_R04
extends AbstractMessage {
    public ORF_R04() {
        this(new DefaultModelClassFactory());
    }

    public ORF_R04(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(MSA.class, true, false);
            this.add(QRD.class, true, false);
            this.add(QRF.class, false, false);
            this.add(ORF_R04_QUERY_RESPONSE.class, true, true);
            this.add(ERR.class, false, true);
            this.add(QAK.class, false, false);
            this.add(DSC.class, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ORF_R04 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.6";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return this.getTyped("UAC", UAC.class);
    }

    public MSA getMSA() {
        return this.getTyped("MSA", MSA.class);
    }

    public QRD getQRD() {
        return this.getTyped("QRD", QRD.class);
    }

    public QRF getQRF() {
        return this.getTyped("QRF", QRF.class);
    }

    public ORF_R04_QUERY_RESPONSE getQUERY_RESPONSE() {
        return this.getTyped("QUERY_RESPONSE", ORF_R04_QUERY_RESPONSE.class);
    }

    public ORF_R04_QUERY_RESPONSE getQUERY_RESPONSE(int rep) {
        return this.getTyped("QUERY_RESPONSE", rep, ORF_R04_QUERY_RESPONSE.class);
    }

    public int getQUERY_RESPONSEReps() {
        return this.getReps("QUERY_RESPONSE");
    }

    public List<ORF_R04_QUERY_RESPONSE> getQUERY_RESPONSEAll() throws HL7Exception {
        return this.getAllAsList("QUERY_RESPONSE", ORF_R04_QUERY_RESPONSE.class);
    }

    public void insertQUERY_RESPONSE(ORF_R04_QUERY_RESPONSE structure, int rep) throws HL7Exception {
        super.insertRepetition("QUERY_RESPONSE", structure, rep);
    }

    public ORF_R04_QUERY_RESPONSE insertQUERY_RESPONSE(int rep) throws HL7Exception {
        return (ORF_R04_QUERY_RESPONSE)super.insertRepetition("QUERY_RESPONSE", rep);
    }

    public ORF_R04_QUERY_RESPONSE removeQUERY_RESPONSE(int rep) throws HL7Exception {
        return (ORF_R04_QUERY_RESPONSE)super.removeRepetition("QUERY_RESPONSE", rep);
    }

    public ERR getERR() {
        return this.getTyped("ERR", ERR.class);
    }

    public ERR getERR(int rep) {
        return this.getTyped("ERR", rep, ERR.class);
    }

    public int getERRReps() {
        return this.getReps("ERR");
    }

    public List<ERR> getERRAll() throws HL7Exception {
        return this.getAllAsList("ERR", ERR.class);
    }

    public void insertERR(ERR structure, int rep) throws HL7Exception {
        super.insertRepetition("ERR", structure, rep);
    }

    public ERR insertERR(int rep) throws HL7Exception {
        return (ERR)super.insertRepetition("ERR", rep);
    }

    public ERR removeERR(int rep) throws HL7Exception {
        return (ERR)super.removeRepetition("ERR", rep);
    }

    public QAK getQAK() {
        return this.getTyped("QAK", QAK.class);
    }

    public DSC getDSC() {
        return this.getTyped("DSC", DSC.class);
    }
}

