/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v251.datatype.CQ;
import ca.uhn.hl7v2.model.v251.datatype.EI;
import ca.uhn.hl7v2.model.v251.datatype.ID;
import ca.uhn.hl7v2.model.v251.datatype.NM;
import ca.uhn.hl7v2.model.v251.datatype.SI;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class TQ2
extends AbstractSegment {
    public TQ2(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, false, 1, 4, new Object[]{this.getMessage()}, "Set ID - TQ2");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(503)}, "Sequence/Results Flag");
            this.add(EI.class, false, 0, 22, new Object[]{this.getMessage()}, "Related Placer Number");
            this.add(EI.class, false, 0, 22, new Object[]{this.getMessage()}, "Related Filler Number");
            this.add(EI.class, false, 0, 22, new Object[]{this.getMessage()}, "Related Placer Group Number");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(504)}, "Sequence Condition Code");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(505)}, "Cyclic Entry/Exit Indicator");
            this.add(CQ.class, false, 1, 20, new Object[]{this.getMessage()}, "Sequence Condition Time Interval");
            this.add(NM.class, false, 1, 10, new Object[]{this.getMessage()}, "Cyclic Group Maximum Number of Repeats");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(506)}, "Special Service Request Relationship");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating TQ2 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDTQ2() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getTq21_SetIDTQ2() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getSequenceResultsFlag() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getTq22_SequenceResultsFlag() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public EI[] getRelatedPlacerNumber() {
        EI[] retVal = (EI[])this.getTypedField(3, new EI[0]);
        return retVal;
    }

    public EI[] getTq23_RelatedPlacerNumber() {
        EI[] retVal = (EI[])this.getTypedField(3, new EI[0]);
        return retVal;
    }

    public int getRelatedPlacerNumberReps() {
        return this.getReps(3);
    }

    public EI getRelatedPlacerNumber(int rep) {
        EI retVal = (EI)this.getTypedField(3, rep);
        return retVal;
    }

    public EI getTq23_RelatedPlacerNumber(int rep) {
        EI retVal = (EI)this.getTypedField(3, rep);
        return retVal;
    }

    public int getTq23_RelatedPlacerNumberReps() {
        return this.getReps(3);
    }

    public EI insertRelatedPlacerNumber(int rep) throws HL7Exception {
        return (EI)super.insertRepetition(3, rep);
    }

    public EI insertTq23_RelatedPlacerNumber(int rep) throws HL7Exception {
        return (EI)super.insertRepetition(3, rep);
    }

    public EI removeRelatedPlacerNumber(int rep) throws HL7Exception {
        return (EI)super.removeRepetition(3, rep);
    }

    public EI removeTq23_RelatedPlacerNumber(int rep) throws HL7Exception {
        return (EI)super.removeRepetition(3, rep);
    }

    public EI[] getRelatedFillerNumber() {
        EI[] retVal = (EI[])this.getTypedField(4, new EI[0]);
        return retVal;
    }

    public EI[] getTq24_RelatedFillerNumber() {
        EI[] retVal = (EI[])this.getTypedField(4, new EI[0]);
        return retVal;
    }

    public int getRelatedFillerNumberReps() {
        return this.getReps(4);
    }

    public EI getRelatedFillerNumber(int rep) {
        EI retVal = (EI)this.getTypedField(4, rep);
        return retVal;
    }

    public EI getTq24_RelatedFillerNumber(int rep) {
        EI retVal = (EI)this.getTypedField(4, rep);
        return retVal;
    }

    public int getTq24_RelatedFillerNumberReps() {
        return this.getReps(4);
    }

    public EI insertRelatedFillerNumber(int rep) throws HL7Exception {
        return (EI)super.insertRepetition(4, rep);
    }

    public EI insertTq24_RelatedFillerNumber(int rep) throws HL7Exception {
        return (EI)super.insertRepetition(4, rep);
    }

    public EI removeRelatedFillerNumber(int rep) throws HL7Exception {
        return (EI)super.removeRepetition(4, rep);
    }

    public EI removeTq24_RelatedFillerNumber(int rep) throws HL7Exception {
        return (EI)super.removeRepetition(4, rep);
    }

    public EI[] getRelatedPlacerGroupNumber() {
        EI[] retVal = (EI[])this.getTypedField(5, new EI[0]);
        return retVal;
    }

    public EI[] getTq25_RelatedPlacerGroupNumber() {
        EI[] retVal = (EI[])this.getTypedField(5, new EI[0]);
        return retVal;
    }

    public int getRelatedPlacerGroupNumberReps() {
        return this.getReps(5);
    }

    public EI getRelatedPlacerGroupNumber(int rep) {
        EI retVal = (EI)this.getTypedField(5, rep);
        return retVal;
    }

    public EI getTq25_RelatedPlacerGroupNumber(int rep) {
        EI retVal = (EI)this.getTypedField(5, rep);
        return retVal;
    }

    public int getTq25_RelatedPlacerGroupNumberReps() {
        return this.getReps(5);
    }

    public EI insertRelatedPlacerGroupNumber(int rep) throws HL7Exception {
        return (EI)super.insertRepetition(5, rep);
    }

    public EI insertTq25_RelatedPlacerGroupNumber(int rep) throws HL7Exception {
        return (EI)super.insertRepetition(5, rep);
    }

    public EI removeRelatedPlacerGroupNumber(int rep) throws HL7Exception {
        return (EI)super.removeRepetition(5, rep);
    }

    public EI removeTq25_RelatedPlacerGroupNumber(int rep) throws HL7Exception {
        return (EI)super.removeRepetition(5, rep);
    }

    public ID getSequenceConditionCode() {
        ID retVal = (ID)this.getTypedField(6, 0);
        return retVal;
    }

    public ID getTq26_SequenceConditionCode() {
        ID retVal = (ID)this.getTypedField(6, 0);
        return retVal;
    }

    public ID getCyclicEntryExitIndicator() {
        ID retVal = (ID)this.getTypedField(7, 0);
        return retVal;
    }

    public ID getTq27_CyclicEntryExitIndicator() {
        ID retVal = (ID)this.getTypedField(7, 0);
        return retVal;
    }

    public CQ getSequenceConditionTimeInterval() {
        CQ retVal = (CQ)this.getTypedField(8, 0);
        return retVal;
    }

    public CQ getTq28_SequenceConditionTimeInterval() {
        CQ retVal = (CQ)this.getTypedField(8, 0);
        return retVal;
    }

    public NM getCyclicGroupMaximumNumberOfRepeats() {
        NM retVal = (NM)this.getTypedField(9, 0);
        return retVal;
    }

    public NM getTq29_CyclicGroupMaximumNumberOfRepeats() {
        NM retVal = (NM)this.getTypedField(9, 0);
        return retVal;
    }

    public ID getSpecialServiceRequestRelationship() {
        ID retVal = (ID)this.getTypedField(10, 0);
        return retVal;
    }

    public ID getTq210_SpecialServiceRequestRelationship() {
        ID retVal = (ID)this.getTypedField(10, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new ID(this.getMessage(), new Integer(503));
            }
            case 2: {
                return new EI(this.getMessage());
            }
            case 3: {
                return new EI(this.getMessage());
            }
            case 4: {
                return new EI(this.getMessage());
            }
            case 5: {
                return new ID(this.getMessage(), new Integer(504));
            }
            case 6: {
                return new ID(this.getMessage(), new Integer(505));
            }
            case 7: {
                return new CQ(this.getMessage());
            }
            case 8: {
                return new NM(this.getMessage());
            }
            case 9: {
                return new ID(this.getMessage(), new Integer(506));
            }
        }
        return null;
    }
}

