/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v25.segment.MFE;
import ca.uhn.hl7v2.model.v25.segment.MFI;
import ca.uhn.hl7v2.model.v25.segment.MSH;
import ca.uhn.hl7v2.model.v25.segment.SFT;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MFN_M13
extends AbstractMessage {
    public MFN_M13() {
        this(new DefaultModelClassFactory());
    }

    public MFN_M13(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(MFI.class, true, false);
            this.add(MFE.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating MFN_M13 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.5";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public MFI getMFI() {
        return this.getTyped("MFI", MFI.class);
    }

    public MFE getMFE() {
        return this.getTyped("MFE", MFE.class);
    }

    public MFE getMFE(int rep) {
        return this.getTyped("MFE", rep, MFE.class);
    }

    public int getMFEReps() {
        return this.getReps("MFE");
    }

    public List<MFE> getMFEAll() throws HL7Exception {
        return this.getAllAsList("MFE", MFE.class);
    }

    public void insertMFE(MFE structure, int rep) throws HL7Exception {
        super.insertRepetition("MFE", structure, rep);
    }

    public MFE insertMFE(int rep) throws HL7Exception {
        return (MFE)super.insertRepetition("MFE", rep);
    }

    public MFE removeMFE(int rep) throws HL7Exception {
        return (MFE)super.removeRepetition("MFE", rep);
    }
}

