/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v24.datatype.CE;
import ca.uhn.hl7v2.model.v24.datatype.CQ;
import ca.uhn.hl7v2.model.v24.datatype.ID;
import ca.uhn.hl7v2.model.v24.datatype.IS;
import ca.uhn.hl7v2.model.v24.datatype.ST;
import ca.uhn.hl7v2.model.v24.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class PCR
extends AbstractSegment {
    public PCR(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CE.class, true, 1, 250, new Object[]{this.getMessage()}, "Implicated Product");
            this.add(IS.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(249)}, "Generic Product");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Product Class");
            this.add(CQ.class, false, 1, 8, new Object[]{this.getMessage()}, "Total Duration Of Therapy");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Product Manufacture Date");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Product Expiration Date");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Product Implantation Date");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Product Explantation Date");
            this.add(IS.class, false, 1, 8, new Object[]{this.getMessage(), new Integer(244)}, "Single Use Device");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Indication For Product Use");
            this.add(IS.class, false, 1, 8, new Object[]{this.getMessage(), new Integer(245)}, "Product Problem");
            this.add(ST.class, false, 3, 30, new Object[]{this.getMessage()}, "Product Serial/Lot Number");
            this.add(IS.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(246)}, "Product Available For Inspection");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Product Evaluation Performed");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Product Evaluation Status");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Product Evaluation Results");
            this.add(ID.class, false, 1, 8, new Object[]{this.getMessage(), new Integer(248)}, "Evaluated Product Source");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Date Product Returned To Manufacturer");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(242)}, "Device Operator Qualifications");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(250)}, "Relatedness Assessment");
            this.add(ID.class, false, 6, 2, new Object[]{this.getMessage(), new Integer(251)}, "Action Taken In Response To The Event");
            this.add(ID.class, false, 6, 2, new Object[]{this.getMessage(), new Integer(252)}, "Event Causality Observations");
            this.add(ID.class, false, 3, 1, new Object[]{this.getMessage(), new Integer(253)}, "Indirect Exposure Mechanism");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PCR - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public CE getImplicatedProduct() {
        CE retVal = (CE)this.getTypedField(1, 0);
        return retVal;
    }

    public CE getPcr1_ImplicatedProduct() {
        CE retVal = (CE)this.getTypedField(1, 0);
        return retVal;
    }

    public IS getGenericProduct() {
        IS retVal = (IS)this.getTypedField(2, 0);
        return retVal;
    }

    public IS getPcr2_GenericProduct() {
        IS retVal = (IS)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getProductClass() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getPcr3_ProductClass() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public CQ getTotalDurationOfTherapy() {
        CQ retVal = (CQ)this.getTypedField(4, 0);
        return retVal;
    }

    public CQ getPcr4_TotalDurationOfTherapy() {
        CQ retVal = (CQ)this.getTypedField(4, 0);
        return retVal;
    }

    public TS getProductManufactureDate() {
        TS retVal = (TS)this.getTypedField(5, 0);
        return retVal;
    }

    public TS getPcr5_ProductManufactureDate() {
        TS retVal = (TS)this.getTypedField(5, 0);
        return retVal;
    }

    public TS getProductExpirationDate() {
        TS retVal = (TS)this.getTypedField(6, 0);
        return retVal;
    }

    public TS getPcr6_ProductExpirationDate() {
        TS retVal = (TS)this.getTypedField(6, 0);
        return retVal;
    }

    public TS getProductImplantationDate() {
        TS retVal = (TS)this.getTypedField(7, 0);
        return retVal;
    }

    public TS getPcr7_ProductImplantationDate() {
        TS retVal = (TS)this.getTypedField(7, 0);
        return retVal;
    }

    public TS getProductExplantationDate() {
        TS retVal = (TS)this.getTypedField(8, 0);
        return retVal;
    }

    public TS getPcr8_ProductExplantationDate() {
        TS retVal = (TS)this.getTypedField(8, 0);
        return retVal;
    }

    public IS getSingleUseDevice() {
        IS retVal = (IS)this.getTypedField(9, 0);
        return retVal;
    }

    public IS getPcr9_SingleUseDevice() {
        IS retVal = (IS)this.getTypedField(9, 0);
        return retVal;
    }

    public CE getIndicationForProductUse() {
        CE retVal = (CE)this.getTypedField(10, 0);
        return retVal;
    }

    public CE getPcr10_IndicationForProductUse() {
        CE retVal = (CE)this.getTypedField(10, 0);
        return retVal;
    }

    public IS getProductProblem() {
        IS retVal = (IS)this.getTypedField(11, 0);
        return retVal;
    }

    public IS getPcr11_ProductProblem() {
        IS retVal = (IS)this.getTypedField(11, 0);
        return retVal;
    }

    public ST[] getProductSerialLotNumber() {
        ST[] retVal = (ST[])this.getTypedField(12, new ST[0]);
        return retVal;
    }

    public ST[] getPcr12_ProductSerialLotNumber() {
        ST[] retVal = (ST[])this.getTypedField(12, new ST[0]);
        return retVal;
    }

    public int getProductSerialLotNumberReps() {
        return this.getReps(12);
    }

    public ST getProductSerialLotNumber(int rep) {
        ST retVal = (ST)this.getTypedField(12, rep);
        return retVal;
    }

    public ST getPcr12_ProductSerialLotNumber(int rep) {
        ST retVal = (ST)this.getTypedField(12, rep);
        return retVal;
    }

    public int getPcr12_ProductSerialLotNumberReps() {
        return this.getReps(12);
    }

    public ST insertProductSerialLotNumber(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(12, rep);
    }

    public ST insertPcr12_ProductSerialLotNumber(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(12, rep);
    }

    public ST removeProductSerialLotNumber(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(12, rep);
    }

    public ST removePcr12_ProductSerialLotNumber(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(12, rep);
    }

    public IS getProductAvailableForInspection() {
        IS retVal = (IS)this.getTypedField(13, 0);
        return retVal;
    }

    public IS getPcr13_ProductAvailableForInspection() {
        IS retVal = (IS)this.getTypedField(13, 0);
        return retVal;
    }

    public CE getProductEvaluationPerformed() {
        CE retVal = (CE)this.getTypedField(14, 0);
        return retVal;
    }

    public CE getPcr14_ProductEvaluationPerformed() {
        CE retVal = (CE)this.getTypedField(14, 0);
        return retVal;
    }

    public CE getProductEvaluationStatus() {
        CE retVal = (CE)this.getTypedField(15, 0);
        return retVal;
    }

    public CE getPcr15_ProductEvaluationStatus() {
        CE retVal = (CE)this.getTypedField(15, 0);
        return retVal;
    }

    public CE getProductEvaluationResults() {
        CE retVal = (CE)this.getTypedField(16, 0);
        return retVal;
    }

    public CE getPcr16_ProductEvaluationResults() {
        CE retVal = (CE)this.getTypedField(16, 0);
        return retVal;
    }

    public ID getEvaluatedProductSource() {
        ID retVal = (ID)this.getTypedField(17, 0);
        return retVal;
    }

    public ID getPcr17_EvaluatedProductSource() {
        ID retVal = (ID)this.getTypedField(17, 0);
        return retVal;
    }

    public TS getDateProductReturnedToManufacturer() {
        TS retVal = (TS)this.getTypedField(18, 0);
        return retVal;
    }

    public TS getPcr18_DateProductReturnedToManufacturer() {
        TS retVal = (TS)this.getTypedField(18, 0);
        return retVal;
    }

    public ID getDeviceOperatorQualifications() {
        ID retVal = (ID)this.getTypedField(19, 0);
        return retVal;
    }

    public ID getPcr19_DeviceOperatorQualifications() {
        ID retVal = (ID)this.getTypedField(19, 0);
        return retVal;
    }

    public ID getRelatednessAssessment() {
        ID retVal = (ID)this.getTypedField(20, 0);
        return retVal;
    }

    public ID getPcr20_RelatednessAssessment() {
        ID retVal = (ID)this.getTypedField(20, 0);
        return retVal;
    }

    public ID[] getActionTakenInResponseToTheEvent() {
        ID[] retVal = (ID[])this.getTypedField(21, new ID[0]);
        return retVal;
    }

    public ID[] getPcr21_ActionTakenInResponseToTheEvent() {
        ID[] retVal = (ID[])this.getTypedField(21, new ID[0]);
        return retVal;
    }

    public int getActionTakenInResponseToTheEventReps() {
        return this.getReps(21);
    }

    public ID getActionTakenInResponseToTheEvent(int rep) {
        ID retVal = (ID)this.getTypedField(21, rep);
        return retVal;
    }

    public ID getPcr21_ActionTakenInResponseToTheEvent(int rep) {
        ID retVal = (ID)this.getTypedField(21, rep);
        return retVal;
    }

    public int getPcr21_ActionTakenInResponseToTheEventReps() {
        return this.getReps(21);
    }

    public ID insertActionTakenInResponseToTheEvent(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(21, rep);
    }

    public ID insertPcr21_ActionTakenInResponseToTheEvent(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(21, rep);
    }

    public ID removeActionTakenInResponseToTheEvent(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(21, rep);
    }

    public ID removePcr21_ActionTakenInResponseToTheEvent(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(21, rep);
    }

    public ID[] getEventCausalityObservations() {
        ID[] retVal = (ID[])this.getTypedField(22, new ID[0]);
        return retVal;
    }

    public ID[] getPcr22_EventCausalityObservations() {
        ID[] retVal = (ID[])this.getTypedField(22, new ID[0]);
        return retVal;
    }

    public int getEventCausalityObservationsReps() {
        return this.getReps(22);
    }

    public ID getEventCausalityObservations(int rep) {
        ID retVal = (ID)this.getTypedField(22, rep);
        return retVal;
    }

    public ID getPcr22_EventCausalityObservations(int rep) {
        ID retVal = (ID)this.getTypedField(22, rep);
        return retVal;
    }

    public int getPcr22_EventCausalityObservationsReps() {
        return this.getReps(22);
    }

    public ID insertEventCausalityObservations(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(22, rep);
    }

    public ID insertPcr22_EventCausalityObservations(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(22, rep);
    }

    public ID removeEventCausalityObservations(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(22, rep);
    }

    public ID removePcr22_EventCausalityObservations(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(22, rep);
    }

    public ID[] getIndirectExposureMechanism() {
        ID[] retVal = (ID[])this.getTypedField(23, new ID[0]);
        return retVal;
    }

    public ID[] getPcr23_IndirectExposureMechanism() {
        ID[] retVal = (ID[])this.getTypedField(23, new ID[0]);
        return retVal;
    }

    public int getIndirectExposureMechanismReps() {
        return this.getReps(23);
    }

    public ID getIndirectExposureMechanism(int rep) {
        ID retVal = (ID)this.getTypedField(23, rep);
        return retVal;
    }

    public ID getPcr23_IndirectExposureMechanism(int rep) {
        ID retVal = (ID)this.getTypedField(23, rep);
        return retVal;
    }

    public int getPcr23_IndirectExposureMechanismReps() {
        return this.getReps(23);
    }

    public ID insertIndirectExposureMechanism(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(23, rep);
    }

    public ID insertPcr23_IndirectExposureMechanism(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(23, rep);
    }

    public ID removeIndirectExposureMechanism(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(23, rep);
    }

    public ID removePcr23_IndirectExposureMechanism(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(23, rep);
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CE(this.getMessage());
            }
            case 1: {
                return new IS(this.getMessage(), new Integer(249));
            }
            case 2: {
                return new CE(this.getMessage());
            }
            case 3: {
                return new CQ(this.getMessage());
            }
            case 4: {
                return new TS(this.getMessage());
            }
            case 5: {
                return new TS(this.getMessage());
            }
            case 6: {
                return new TS(this.getMessage());
            }
            case 7: {
                return new TS(this.getMessage());
            }
            case 8: {
                return new IS(this.getMessage(), new Integer(244));
            }
            case 9: {
                return new CE(this.getMessage());
            }
            case 10: {
                return new IS(this.getMessage(), new Integer(245));
            }
            case 11: {
                return new ST(this.getMessage());
            }
            case 12: {
                return new IS(this.getMessage(), new Integer(246));
            }
            case 13: {
                return new CE(this.getMessage());
            }
            case 14: {
                return new CE(this.getMessage());
            }
            case 15: {
                return new CE(this.getMessage());
            }
            case 16: {
                return new ID(this.getMessage(), new Integer(248));
            }
            case 17: {
                return new TS(this.getMessage());
            }
            case 18: {
                return new ID(this.getMessage(), new Integer(242));
            }
            case 19: {
                return new ID(this.getMessage(), new Integer(250));
            }
            case 20: {
                return new ID(this.getMessage(), new Integer(251));
            }
            case 21: {
                return new ID(this.getMessage(), new Integer(252));
            }
            case 22: {
                return new ID(this.getMessage(), new Integer(253));
            }
        }
        return null;
    }
}

