/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.datatype;

import ca.uhn.hl7v2.model.AbstractComposite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v24.datatype.CE;
import ca.uhn.hl7v2.model.v24.datatype.ST;
import ca.uhn.hl7v2.model.v24.datatype.TX;

public class PRL
extends AbstractComposite {
    private Type[] data;

    public PRL(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[3];
        this.data[0] = new CE(this.getMessage());
        this.data[1] = new ST(this.getMessage());
        this.data[2] = new TX(this.getMessage());
    }

    public Type[] getComponents() {
        return this.data;
    }

    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + this.getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public CE getOBX3ObservationIdentifierOfParentResult() {
        return this.getTyped(0, CE.class);
    }

    public CE getPrl1_OBX3ObservationIdentifierOfParentResult() {
        return this.getTyped(0, CE.class);
    }

    public ST getOBX4SubIDOfParentResult() {
        return this.getTyped(1, ST.class);
    }

    public ST getPrl2_OBX4SubIDOfParentResult() {
        return this.getTyped(1, ST.class);
    }

    public TX getPartOfOBX5ObservationResultFromParent() {
        return this.getTyped(2, TX.class);
    }

    public TX getPrl3_PartOfOBX5ObservationResultFromParent() {
        return this.getTyped(2, TX.class);
    }
}

