/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v23.datatype.CE;
import ca.uhn.hl7v2.model.v23.datatype.CP;
import ca.uhn.hl7v2.model.v23.datatype.EI;
import ca.uhn.hl7v2.model.v23.datatype.ID;
import ca.uhn.hl7v2.model.v23.datatype.NM;
import ca.uhn.hl7v2.model.v23.datatype.PL;
import ca.uhn.hl7v2.model.v23.datatype.SI;
import ca.uhn.hl7v2.model.v23.datatype.ST;
import ca.uhn.hl7v2.model.v23.datatype.TS;
import ca.uhn.hl7v2.model.v23.datatype.XCN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class FT1
extends AbstractSegment {
    public FT1(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, false, 1, 4, new Object[]{this.getMessage()}, "Set ID - Financial Transaction");
            this.add(ST.class, false, 1, 12, new Object[]{this.getMessage()}, "Transaction ID");
            this.add(ST.class, false, 1, 10, new Object[]{this.getMessage()}, "Transaction Batch ID");
            this.add(TS.class, true, 1, 26, new Object[]{this.getMessage()}, "Transaction Date");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Transaction Posting Date");
            this.add(ID.class, true, 1, 8, new Object[]{this.getMessage(), new Integer(17)}, "Transaction Type");
            this.add(CE.class, true, 1, 80, new Object[]{this.getMessage()}, "Transaction Code");
            this.add(ST.class, false, 1, 40, new Object[]{this.getMessage()}, "Transaction Description");
            this.add(ST.class, false, 1, 40, new Object[]{this.getMessage()}, "Transaction Description - alternate");
            this.add(NM.class, false, 1, 6, new Object[]{this.getMessage()}, "Transaction Quantity");
            this.add(CP.class, false, 1, 12, new Object[]{this.getMessage()}, "Transaction Amount - Extended");
            this.add(CP.class, false, 1, 12, new Object[]{this.getMessage()}, "Transaction Amount - Unit");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Department Code");
            this.add(CE.class, false, 1, 8, new Object[]{this.getMessage()}, "Insurance Plan ID");
            this.add(CP.class, false, 1, 12, new Object[]{this.getMessage()}, "Insurance Amount");
            this.add(PL.class, false, 1, 12, new Object[]{this.getMessage()}, "Assigned Patient Location");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(24)}, "Fee Schedule");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(18)}, "Patient Type");
            this.add(CE.class, false, 0, 60, new Object[]{this.getMessage()}, "Diagnosis Code");
            this.add(XCN.class, false, 1, 120, new Object[]{this.getMessage()}, "Performed By Code");
            this.add(XCN.class, false, 1, 120, new Object[]{this.getMessage()}, "Ordered By Code");
            this.add(NM.class, false, 1, 12, new Object[]{this.getMessage()}, "Unit Cost");
            this.add(EI.class, false, 1, 22, new Object[]{this.getMessage()}, "Filler Order Number");
            this.add(XCN.class, false, 1, 120, new Object[]{this.getMessage()}, "Entered By Code");
            this.add(CE.class, false, 1, 80, new Object[]{this.getMessage()}, "Procedure Code");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating FT1 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDFinancialTransaction() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getFt11_SetIDFinancialTransaction() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public ST getTransactionID() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getFt12_TransactionID() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getTransactionBatchID() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getFt13_TransactionBatchID() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public TS getTransactionDate() {
        TS retVal = (TS)this.getTypedField(4, 0);
        return retVal;
    }

    public TS getFt14_TransactionDate() {
        TS retVal = (TS)this.getTypedField(4, 0);
        return retVal;
    }

    public TS getTransactionPostingDate() {
        TS retVal = (TS)this.getTypedField(5, 0);
        return retVal;
    }

    public TS getFt15_TransactionPostingDate() {
        TS retVal = (TS)this.getTypedField(5, 0);
        return retVal;
    }

    public ID getTransactionType() {
        ID retVal = (ID)this.getTypedField(6, 0);
        return retVal;
    }

    public ID getFt16_TransactionType() {
        ID retVal = (ID)this.getTypedField(6, 0);
        return retVal;
    }

    public CE getTransactionCode() {
        CE retVal = (CE)this.getTypedField(7, 0);
        return retVal;
    }

    public CE getFt17_TransactionCode() {
        CE retVal = (CE)this.getTypedField(7, 0);
        return retVal;
    }

    public ST getTransactionDescription() {
        ST retVal = (ST)this.getTypedField(8, 0);
        return retVal;
    }

    public ST getFt18_TransactionDescription() {
        ST retVal = (ST)this.getTypedField(8, 0);
        return retVal;
    }

    public ST getTransactionDescriptionAlternate() {
        ST retVal = (ST)this.getTypedField(9, 0);
        return retVal;
    }

    public ST getFt19_TransactionDescriptionAlternate() {
        ST retVal = (ST)this.getTypedField(9, 0);
        return retVal;
    }

    public NM getTransactionQuantity() {
        NM retVal = (NM)this.getTypedField(10, 0);
        return retVal;
    }

    public NM getFt110_TransactionQuantity() {
        NM retVal = (NM)this.getTypedField(10, 0);
        return retVal;
    }

    public CP getTransactionAmountExtended() {
        CP retVal = (CP)this.getTypedField(11, 0);
        return retVal;
    }

    public CP getFt111_TransactionAmountExtended() {
        CP retVal = (CP)this.getTypedField(11, 0);
        return retVal;
    }

    public CP getTransactionAmountUnit() {
        CP retVal = (CP)this.getTypedField(12, 0);
        return retVal;
    }

    public CP getFt112_TransactionAmountUnit() {
        CP retVal = (CP)this.getTypedField(12, 0);
        return retVal;
    }

    public CE getDepartmentCode() {
        CE retVal = (CE)this.getTypedField(13, 0);
        return retVal;
    }

    public CE getFt113_DepartmentCode() {
        CE retVal = (CE)this.getTypedField(13, 0);
        return retVal;
    }

    public CE getInsurancePlanID() {
        CE retVal = (CE)this.getTypedField(14, 0);
        return retVal;
    }

    public CE getFt114_InsurancePlanID() {
        CE retVal = (CE)this.getTypedField(14, 0);
        return retVal;
    }

    public CP getInsuranceAmount() {
        CP retVal = (CP)this.getTypedField(15, 0);
        return retVal;
    }

    public CP getFt115_InsuranceAmount() {
        CP retVal = (CP)this.getTypedField(15, 0);
        return retVal;
    }

    public PL getAssignedPatientLocation() {
        PL retVal = (PL)this.getTypedField(16, 0);
        return retVal;
    }

    public PL getFt116_AssignedPatientLocation() {
        PL retVal = (PL)this.getTypedField(16, 0);
        return retVal;
    }

    public ID getFeeSchedule() {
        ID retVal = (ID)this.getTypedField(17, 0);
        return retVal;
    }

    public ID getFt117_FeeSchedule() {
        ID retVal = (ID)this.getTypedField(17, 0);
        return retVal;
    }

    public ID getPatientType() {
        ID retVal = (ID)this.getTypedField(18, 0);
        return retVal;
    }

    public ID getFt118_PatientType() {
        ID retVal = (ID)this.getTypedField(18, 0);
        return retVal;
    }

    public CE[] getDiagnosisCode() {
        CE[] retVal = (CE[])this.getTypedField(19, new CE[0]);
        return retVal;
    }

    public CE[] getFt119_DiagnosisCode() {
        CE[] retVal = (CE[])this.getTypedField(19, new CE[0]);
        return retVal;
    }

    public int getDiagnosisCodeReps() {
        return this.getReps(19);
    }

    public CE getDiagnosisCode(int rep) {
        CE retVal = (CE)this.getTypedField(19, rep);
        return retVal;
    }

    public CE getFt119_DiagnosisCode(int rep) {
        CE retVal = (CE)this.getTypedField(19, rep);
        return retVal;
    }

    public int getFt119_DiagnosisCodeReps() {
        return this.getReps(19);
    }

    public CE insertDiagnosisCode(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(19, rep);
    }

    public CE insertFt119_DiagnosisCode(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(19, rep);
    }

    public CE removeDiagnosisCode(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(19, rep);
    }

    public CE removeFt119_DiagnosisCode(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(19, rep);
    }

    public XCN getPerformedByCode() {
        XCN retVal = (XCN)this.getTypedField(20, 0);
        return retVal;
    }

    public XCN getFt120_PerformedByCode() {
        XCN retVal = (XCN)this.getTypedField(20, 0);
        return retVal;
    }

    public XCN getOrderedByCode() {
        XCN retVal = (XCN)this.getTypedField(21, 0);
        return retVal;
    }

    public XCN getFt121_OrderedByCode() {
        XCN retVal = (XCN)this.getTypedField(21, 0);
        return retVal;
    }

    public NM getUnitCost() {
        NM retVal = (NM)this.getTypedField(22, 0);
        return retVal;
    }

    public NM getFt122_UnitCost() {
        NM retVal = (NM)this.getTypedField(22, 0);
        return retVal;
    }

    public EI getFillerOrderNumber() {
        EI retVal = (EI)this.getTypedField(23, 0);
        return retVal;
    }

    public EI getFt123_FillerOrderNumber() {
        EI retVal = (EI)this.getTypedField(23, 0);
        return retVal;
    }

    public XCN getEnteredByCode() {
        XCN retVal = (XCN)this.getTypedField(24, 0);
        return retVal;
    }

    public XCN getFt124_EnteredByCode() {
        XCN retVal = (XCN)this.getTypedField(24, 0);
        return retVal;
    }

    public CE getProcedureCode() {
        CE retVal = (CE)this.getTypedField(25, 0);
        return retVal;
    }

    public CE getFt125_ProcedureCode() {
        CE retVal = (CE)this.getTypedField(25, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new ST(this.getMessage());
            }
            case 2: {
                return new ST(this.getMessage());
            }
            case 3: {
                return new TS(this.getMessage());
            }
            case 4: {
                return new TS(this.getMessage());
            }
            case 5: {
                return new ID(this.getMessage(), new Integer(17));
            }
            case 6: {
                return new CE(this.getMessage());
            }
            case 7: {
                return new ST(this.getMessage());
            }
            case 8: {
                return new ST(this.getMessage());
            }
            case 9: {
                return new NM(this.getMessage());
            }
            case 10: {
                return new CP(this.getMessage());
            }
            case 11: {
                return new CP(this.getMessage());
            }
            case 12: {
                return new CE(this.getMessage());
            }
            case 13: {
                return new CE(this.getMessage());
            }
            case 14: {
                return new CP(this.getMessage());
            }
            case 15: {
                return new PL(this.getMessage());
            }
            case 16: {
                return new ID(this.getMessage(), new Integer(24));
            }
            case 17: {
                return new ID(this.getMessage(), new Integer(18));
            }
            case 18: {
                return new CE(this.getMessage());
            }
            case 19: {
                return new XCN(this.getMessage());
            }
            case 20: {
                return new XCN(this.getMessage());
            }
            case 21: {
                return new NM(this.getMessage());
            }
            case 22: {
                return new EI(this.getMessage());
            }
            case 23: {
                return new XCN(this.getMessage());
            }
            case 24: {
                return new CE(this.getMessage());
            }
        }
        return null;
    }
}

