/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v23.group.RPA_I11_OBSERVATION;
import ca.uhn.hl7v2.model.v23.segment.NTE;
import ca.uhn.hl7v2.model.v23.segment.OBR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RPA_I11_RESULTS
extends AbstractGroup {
    public RPA_I11_RESULTS(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(OBR.class, true, false, false);
            this.add(NTE.class, false, true, false);
            this.add(RPA_I11_OBSERVATION.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RPA_I11_RESULTS - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3";
    }

    public OBR getOBR() {
        OBR retVal = this.getTyped("OBR", OBR.class);
        return retVal;
    }

    public NTE getNTE() {
        NTE retVal = this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public RPA_I11_OBSERVATION getOBSERVATION() {
        RPA_I11_OBSERVATION retVal = this.getTyped("OBSERVATION", RPA_I11_OBSERVATION.class);
        return retVal;
    }

    public RPA_I11_OBSERVATION getOBSERVATION(int rep) {
        RPA_I11_OBSERVATION retVal = this.getTyped("OBSERVATION", rep, RPA_I11_OBSERVATION.class);
        return retVal;
    }

    public int getOBSERVATIONReps() {
        return this.getReps("OBSERVATION");
    }

    public List<RPA_I11_OBSERVATION> getOBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("OBSERVATION", RPA_I11_OBSERVATION.class);
    }

    public void insertOBSERVATION(RPA_I11_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATION", structure, rep);
    }

    public RPA_I11_OBSERVATION insertOBSERVATION(int rep) throws HL7Exception {
        return (RPA_I11_OBSERVATION)super.insertRepetition("OBSERVATION", rep);
    }

    public RPA_I11_OBSERVATION removeOBSERVATION(int rep) throws HL7Exception {
        return (RPA_I11_OBSERVATION)super.removeRepetition("OBSERVATION", rep);
    }
}

