/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.Location;
import ca.uhn.hl7v2.model.MessageVisitor;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.Visitable;

public class Field
implements Visitable {
    private Type[] reps;
    private int maxCardinality;

    public Field(Type[] reps, int maxCardinality) {
        this.reps = reps;
        this.maxCardinality = maxCardinality;
    }

    public boolean accept(MessageVisitor visitor, Location currentLocation) throws HL7Exception {
        if (visitor.start(this, currentLocation)) {
            Type t;
            for (int i = 0; i < this.reps.length && (t = this.reps[i]).accept(visitor, currentLocation); ++i) {
            }
        }
        return visitor.end(this, currentLocation);
    }

    public Location provideLocation(Location parentLocation, int index, int repetition) {
        return new Location(parentLocation).withField(index);
    }

    public boolean isEmpty() throws HL7Exception {
        return this.reps.length == 0;
    }
}

