/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.protocol.impl;

import ca.uhn.hl7v2.protocol.TransportException;
import ca.uhn.hl7v2.protocol.impl.AbstractJMSTransport;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;

public class JMSTopicTransport
extends AbstractJMSTransport {
    private TopicSession mySendingSession;
    private TopicSession myReceivingSession;
    private TopicPublisher myPublisher;
    private TopicSubscriber mySubscriber;
    private final TopicConnection myConnection;
    private final Topic myTopic;
    private String myMessageSelector;

    public JMSTopicTransport(TopicConnection theConnection, Topic theDestination) {
        this.myConnection = theConnection;
        this.myTopic = theDestination;
    }

    public JMSTopicTransport(TopicConnection theConnection, Topic theDestination, String theMessageSelector) {
        this.myConnection = theConnection;
        this.myTopic = theDestination;
        this.myMessageSelector = theMessageSelector;
    }

    @Override
    protected String getDestinationName() throws JMSException {
        return this.myTopic.getTopicName();
    }

    @Override
    public Connection getConnection() {
        return this.myConnection;
    }

    @Override
    protected Message getMessage() throws JMSException {
        return this.mySendingSession.createTextMessage();
    }

    @Override
    protected void sendJMS(Message theMessage) throws JMSException {
        this.myPublisher.publish(theMessage);
    }

    @Override
    protected Message receiveJMS() throws JMSException {
        return this.mySubscriber.receive();
    }

    @Override
    public void doConnect() throws TransportException {
        boolean transacted = false;
        int ackMode = 1;
        this.doDisconnect();
        try {
            this.mySendingSession = this.myConnection.createTopicSession(transacted, ackMode);
            this.myPublisher = this.mySendingSession.createPublisher(this.myTopic);
            this.myReceivingSession = this.myConnection.createTopicSession(transacted, ackMode);
            this.mySubscriber = this.myReceivingSession.createSubscriber(this.myTopic);
        }
        catch (JMSException e) {
            throw new TransportException(e);
        }
    }

    @Override
    public void doDisconnect() throws TransportException {
        try {
            if (this.mySendingSession != null) {
                this.mySendingSession.close();
            }
            if (this.myReceivingSession != null) {
                this.myReceivingSession.close();
            }
        }
        catch (JMSException e) {
            throw new TransportException(e);
        }
    }
}

