/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.parser;

import ca.uhn.hl7v2.ErrorCode;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.Version;
import ca.uhn.hl7v2.model.GenericMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.parser.AbstractModelClassFactory;
import ca.uhn.hl7v2.parser.Parser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultModelClassFactory
extends AbstractModelClassFactory {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(DefaultModelClassFactory.class);
    static final String CUSTOM_PACKAGES_RESOURCE_NAME_TEMPLATE = "custom_packages/{0}";
    private static final Map<String, String[]> packages = new HashMap<String, String[]>();
    private static List<String> ourVersions = null;

    @Override
    public Class<? extends Message> getMessageClass(String theName, String theVersion, boolean isExplicit) throws HL7Exception {
        Class<Object> mc;
        if (!isExplicit) {
            theName = this.getMessageStructureForEvent(theName, Version.versionOf(theVersion));
        }
        if ((mc = DefaultModelClassFactory.findClass(theName, theVersion, "message")) == null) {
            mc = GenericMessage.getGenericMessageClass(theVersion);
        }
        return mc;
    }

    @Override
    public Class<? extends Group> getGroupClass(String theName, String theVersion) throws HL7Exception {
        return DefaultModelClassFactory.findClass(theName, theVersion, "group");
    }

    @Override
    public Class<? extends Segment> getSegmentClass(String theName, String theVersion) throws HL7Exception {
        return DefaultModelClassFactory.findClass(theName, theVersion, "segment");
    }

    @Override
    public Class<? extends Type> getTypeClass(String theName, String theVersion) throws HL7Exception {
        return DefaultModelClassFactory.findClass(theName, theVersion, "datatype");
    }

    @Override
    public Class<? extends Message> getMessageClassInASpecificPackage(String theName, String theVersion, boolean isExplicit, String packageName) throws HL7Exception {
        Class<Object> mc;
        if (!isExplicit) {
            theName = this.getMessageStructureForEvent(theName, Version.versionOf(theVersion));
        }
        if ((mc = DefaultModelClassFactory.findClassInASpecificPackage(theName, theVersion, "message", packageName)) == null) {
            mc = GenericMessage.getGenericMessageClass(theVersion);
        }
        return mc;
    }

    private static Class<?> findClassInASpecificPackage(String name, String version, String type, String packageName) throws HL7Exception {
        if (packageName == null || packageName.length() == 0) {
            return DefaultModelClassFactory.findClass(name, version, type);
        }
        String classNameToTry = packageName + "." + name;
        try {
            return Class.forName(classNameToTry);
        }
        catch (ClassNotFoundException e) {
            if (log.isDebugEnabled()) {
                log.debug("Unable to find class " + classNameToTry + ", using default", (Throwable)e);
            }
            return DefaultModelClassFactory.findClass(name, version, type);
        }
    }

    public static String getVersionPackagePath(String ver) throws HL7Exception {
        Version v = Version.versionOf(ver);
        if (v == null) {
            throw new HL7Exception("The HL7 version " + ver + " is unknown", ErrorCode.UNSUPPORTED_VERSION_ID);
        }
        String pkg = v.modelPackageName();
        return pkg.replace('.', '/');
    }

    public static String getVersionPackageName(String ver) throws HL7Exception {
        String path = DefaultModelClassFactory.getVersionPackagePath(ver);
        String packg = path.replace('/', '.');
        packg = packg.replace('\\', '.');
        return packg;
    }

    public static String[] packageList(String version) {
        return packages.get(version);
    }

    private static String[] loadPackages(String version) throws HL7Exception {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String customPackagesResourceName = MessageFormat.format(CUSTOM_PACKAGES_RESOURCE_NAME_TEMPLATE, version);
        InputStream resourceInputStream = classLoader.getResourceAsStream(customPackagesResourceName);
        ArrayList<String> packageList = new ArrayList<String>();
        if (resourceInputStream != null) {
            try (BufferedReader in = new BufferedReader(new InputStreamReader(resourceInputStream));){
                String line = in.readLine();
                while (line != null) {
                    log.info("Adding package to user-defined package list: {}", (Object)line);
                    packageList.add(line);
                    line = in.readLine();
                }
            }
            catch (IOException e) {
                log.error("Can't load all the custom package list - user-defined classes may not be recognized", (Throwable)e);
            }
        } else {
            log.debug("No user-defined packages for version {}", (Object)version);
        }
        packageList.add(DefaultModelClassFactory.getVersionPackageName(version));
        return packageList.toArray(new String[0]);
    }

    private static Class<?> findClass(String name, String version, String type) throws HL7Exception {
        Parser.assertVersionExists(version);
        String[] packageList = DefaultModelClassFactory.packageList(version);
        if (packageList == null) {
            return null;
        }
        String types = "message|group|segment|datatype";
        if (!types.contains(type)) {
            throw new HL7Exception("Can't find " + name + " for version " + version + " -- type must be " + types + " but is " + type);
        }
        Class<?> compClass = null;
        for (int c = 0; compClass == null && c < packageList.length; ++c) {
            String classNameToTry = null;
            try {
                Object p = packageList[c];
                if (!((String)p).endsWith(".")) {
                    p = (String)p + ".";
                }
                classNameToTry = (String)p + type + "." + name;
                if (log.isDebugEnabled()) {
                    log.debug("Trying to load: {}", (Object)classNameToTry);
                }
                compClass = Class.forName(classNameToTry);
                if (!log.isDebugEnabled()) continue;
                log.debug("Loaded: {} class: {}", (Object)classNameToTry, compClass);
                continue;
            }
            catch (ClassNotFoundException cne) {
                log.debug("Failed to load: {}", classNameToTry);
            }
        }
        return compClass;
    }

    public static void reloadPackages() {
        packages.clear();
        ourVersions = new ArrayList<String>();
        for (Version v : Version.values()) {
            try {
                String[] versionPackages = DefaultModelClassFactory.loadPackages(v.getVersion());
                if (versionPackages.length > 0) {
                    ourVersions.add(v.getVersion());
                }
                packages.put(v.getVersion(), versionPackages);
            }
            catch (HL7Exception e) {
                throw new Error("Version \"" + v.getVersion() + "\" is invalid. This is a programming error: ", e);
            }
        }
    }

    public static String getHighestKnownVersion() {
        if (ourVersions == null || ourVersions.size() == 0) {
            return null;
        }
        return ourVersions.get(ourVersions.size() - 1);
    }

    @Override
    public String getMessageStructureForEvent(String name, Version version) throws HL7Exception {
        String structure = super.getMessageStructureForEvent(name, version);
        return structure != null ? structure : name;
    }

    static {
        DefaultModelClassFactory.reloadPackages();
    }
}

