/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.Location;
import ca.uhn.hl7v2.model.ExtraComponents;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.parser.EncodingCharacters;
import ca.uhn.hl7v2.parser.PipeParser;

public abstract class AbstractType
implements Type {
    private static final long serialVersionUID = -6976260024197429201L;
    private final ExtraComponents extra;
    private final Message message;

    public AbstractType(Message message) {
        this.extra = new ExtraComponents(message);
        this.message = message;
    }

    @Override
    public String getName() {
        String longClassName = this.getClass().getName();
        return longClassName.substring(longClassName.lastIndexOf(46) + 1);
    }

    @Override
    public ExtraComponents getExtraComponents() {
        return this.extra;
    }

    @Override
    public Message getMessage() {
        return this.message;
    }

    @Override
    public void parse(String string) throws HL7Exception {
        this.clear();
        this.getMessage().getParser().parse(this, string, EncodingCharacters.getInstance(this.getMessage()));
    }

    @Override
    public String encode() throws HL7Exception {
        return this.getMessage().getParser().doEncode(this, EncodingCharacters.getInstance(this.getMessage()));
    }

    @Override
    public void clear() {
        this.extra.clear();
    }

    @Override
    public boolean isEmpty() throws HL7Exception {
        return this.extra.isEmpty();
    }

    public String toString() {
        return AbstractType.toString(this);
    }

    static String toString(Type theType) {
        StringBuilder b = new StringBuilder();
        b.append(theType.getClass().getSimpleName());
        b.append("[");
        b.append(PipeParser.encode(theType, EncodingCharacters.defaultInstance()));
        b.append("]");
        return b.toString();
    }

    @Override
    public Location provideLocation(Location location, int index, int repetition) {
        if (location.getField() < 0) {
            return new Location(location).withField(index).withFieldRepetition(repetition);
        }
        if (location.getComponent() < 0) {
            return new Location(location).withComponent(index);
        }
        return new Location(location).withSubcomponent(index);
    }
}

