/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.app;

import ca.uhn.hl7v2.app.ActiveConnection;
import ca.uhn.hl7v2.app.Connection;
import ca.uhn.hl7v2.app.ConnectionData;
import ca.uhn.hl7v2.app.LazyConnection;
import ca.uhn.hl7v2.util.SocketFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.ExecutorService;

class ConnectionFactory {
    ConnectionFactory() {
    }

    public static Connection open(ConnectionData connectionData, ExecutorService executorService) throws Exception {
        return connectionData.isLazy() ? new LazyConnection(connectionData, executorService) : ConnectionFactory.openEagerly(connectionData, executorService);
    }

    public static Connection openEagerly(ConnectionData connectionData, ExecutorService executorService) throws Exception {
        ActiveConnection connection;
        if (connectionData.getPort2() == 0) {
            connection = new ActiveConnection(connectionData.getParser(), connectionData.getProtocol(), ConnectionFactory.createSocket(connectionData.getSocketFactory(), connectionData.getHost(), connectionData.getPort(), connectionData.isTls()), executorService);
        } else {
            Socket outbound = ConnectionFactory.createSocket(connectionData.getSocketFactory(), connectionData.getHost(), connectionData.getPort(), connectionData.isTls());
            Socket inbound = ConnectionFactory.createSocket(connectionData.getSocketFactory(), connectionData.getHost(), connectionData.getPort2(), connectionData.isTls());
            connection = new ActiveConnection(connectionData.getParser(), connectionData.getProtocol(), inbound, outbound, executorService);
        }
        connection.activate();
        return connection;
    }

    private static Socket createSocket(SocketFactory socketFactory, String host, int port, boolean tls) throws IOException {
        Socket socket = tls ? socketFactory.createTlsSocket() : socketFactory.createSocket();
        socket.connect(new InetSocketAddress(host, port));
        return socket;
    }
}

