/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.tests.execution;

import org.hl7.fhir.utilities.tests.execution.CliTestException;
import org.hl7.fhir.utilities.tests.execution.CliTestSummary;
import org.slf4j.Logger;

public abstract class ModuleTestExecutor {
    private static final String FAILURE_SUMMARY_TEMPLATE = "Test failures for module %s (%d):";
    private static final String STARTING_TEST_TEMPLATE = "Starting: %s";
    private static final String FINISHED_TEST_TEMPLATE = "Finished: %s with result: %s";
    private static final String FAILED_TEST_TEMPLATE = "Failed Test ID: %s";

    public static void logSummary(Logger log, CliTestSummary testExecutionSummary, String moduleName) {
        log.info("\n" + String.format(FAILURE_SUMMARY_TEMPLATE, moduleName, testExecutionSummary.getTestsFailedCount()));
        for (CliTestException failure : testExecutionSummary.getExceptions()) {
            log.info("\t" + failure.getTestId() + ": " + failure.getException().getMessage());
        }
        log.info("");
    }

    public static void printTestStarted(Logger log, String displayName) {
        log.info(String.format(STARTING_TEST_TEMPLATE, displayName));
    }

    public static void printTestFailed(Logger log, String uniqueIdentifier, Throwable throwable) {
        log.info(String.format(FAILED_TEST_TEMPLATE, uniqueIdentifier));
        if (throwable != null) {
            throwable.printStackTrace(System.out);
        }
    }

    public static void printTestFinished(Logger log, String displayName, String status) {
        log.info(String.format(FINISHED_TEST_TEMPLATE, displayName, status));
    }

    public abstract String getModuleName();

    public abstract CliTestSummary executeTests(Logger var1, String var2);
}

