/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.json.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hl7.fhir.utilities.json.JsonException;
import org.hl7.fhir.utilities.json.model.JsonElement;
import org.hl7.fhir.utilities.json.model.JsonElementType;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.json.model.JsonPrimitive;
import org.hl7.fhir.utilities.json.model.JsonString;

public class JsonArray
extends JsonElement
implements Iterable<JsonElement> {
    private List<JsonElement> items = new ArrayList<JsonElement>();
    private List<Boolean> noCommas;
    private List<Boolean> unQuoted;
    private boolean extraComma;

    public List<String> asStrings() {
        ArrayList<String> list = new ArrayList<String>();
        for (JsonElement n : this.items) {
            if (!(n instanceof JsonPrimitive)) continue;
            list.add(n.asJsonPrimitive().getValue());
        }
        return list;
    }

    public List<JsonElement> getItems() {
        return this.items;
    }

    public List<JsonObject> asJsonObjects() {
        ArrayList<JsonObject> list = new ArrayList<JsonObject>();
        for (JsonElement n : this.items) {
            if (!(n instanceof JsonObject)) continue;
            list.add((JsonObject)n);
        }
        return list;
    }

    @Override
    public JsonElementType type() {
        return JsonElementType.ARRAY;
    }

    public JsonArray add(JsonElement node) throws JsonException {
        this.check(node != null, "null object in JsonArray.add()");
        this.items.add(node);
        return this;
    }

    public JsonArray add(int i, JsonElement node) throws JsonException {
        this.check(node != null, "null object in JsonArray.add()");
        this.items.add(i, node);
        return this;
    }

    public JsonArray add(String value) throws JsonException {
        this.check(value != null, "null value in JsonArray.add()");
        this.items.add(new JsonString(value));
        return this;
    }

    public JsonObject addObject() {
        JsonObject res = new JsonObject();
        this.add(res);
        return res;
    }

    public Integer size() {
        return this.items.size();
    }

    public boolean isNoComma(int i) {
        return this.noCommas == null ? false : this.noCommas.get(i);
    }

    public boolean isUnquoted(int i) {
        return this.unQuoted == null ? false : this.unQuoted.get(i);
    }

    public void addForParser(JsonElement e, boolean itemNoComma, boolean unquoted) throws JsonException {
        this.check(e != null, "null object in JsonArray.add()");
        this.items.add(e);
        if (this.noCommas == null) {
            this.noCommas = new ArrayList<Boolean>();
        }
        this.noCommas.add(itemNoComma);
        if (this.unQuoted == null) {
            this.unQuoted = new ArrayList<Boolean>();
        }
        this.unQuoted.add(unquoted);
    }

    public JsonObject findByStringProp(String prop, String value) {
        for (JsonObject obj : this.asJsonObjects()) {
            if (!obj.has(prop) || !value.equals(obj.asString(prop))) continue;
            return obj;
        }
        return null;
    }

    @Override
    public Iterator<JsonElement> iterator() {
        return this.items.iterator();
    }

    public JsonElement get(int i) {
        return this.items.get(i);
    }

    @Override
    public JsonArray deepCopy() {
        return (JsonArray)this.make().copy(this);
    }

    @Override
    protected JsonElement copy(JsonElement other) {
        JsonArray o = (JsonArray)other;
        for (JsonElement p : o.getItems()) {
            this.add(p.deepCopy());
        }
        return this;
    }

    @Override
    protected JsonElement make() {
        return new JsonArray();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("[ ");
        boolean first = true;
        for (JsonElement p : this.items) {
            if (first) {
                first = false;
            } else {
                b.append(", ");
            }
            b.append(p.toString());
        }
        b.append(" ]");
        return b.toString();
    }

    public boolean isExtraComma() {
        return this.extraComma;
    }

    public void setExtraComma(boolean extraComma) {
        this.extraComma = extraComma;
    }

    public void remove(JsonElement e) {
        this.items.remove(e);
    }

    public boolean has(String key) {
        for (JsonElement e : this.items) {
            if (!e.isJsonString() || !key.equals(e.asString())) continue;
            return true;
        }
        return false;
    }

    public void addAll(JsonArray src) {
        for (JsonElement e : src) {
            this.add(e);
        }
    }
}

